/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.ConfigSection;
import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.configuration.InvalidConfigurationException;
import io.github.portlek.configs.util.Provided;
import io.github.portlek.configs.util.Replaceable;
import io.github.portlek.configs.yaml.FileConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManaged
extends ConfigSection
implements FlManaged {
    private final Map<String, Object> objects = new HashMap<String, Object>();
    private final Map<Class<?>, Provided<?>> customs = new HashMap();
    @Nullable
    private File file;
    private boolean autosave = false;
    private long lastreload = 0L;

    @SafeVarargs
    protected FileManaged(Map.Entry<String, Object> ... objects) {
        Arrays.asList(objects).forEach(entry -> this.addObject((String)entry.getKey(), entry.getValue()));
        this.customs.put(Replaceable.class, new Replaceable.Provider());
    }

    @Override
    @NotNull
    public final Optional<Object> pull(@NotNull String id) {
        return Optional.ofNullable(this.objects.get(id));
    }

    @Override
    public void setup(@NotNull File file, @NotNull FileConfiguration fileConfiguration) {
        this.file = file;
        this.setup(this, (ConfigurationSection)fileConfiguration);
    }

    @Override
    public final <T> void addCustomValue(@NotNull Class<T> aClass, @NotNull Provided<T> provided) {
        this.customs.put(aClass, provided);
    }

    @Override
    @NotNull
    public final <T> Optional<Provided<T>> getCustomValue(@NotNull Class<T> aClass) {
        return this.customs.keySet().stream().filter(aClass::equals).findFirst().map(clss -> this.customs.get(clss));
    }

    @Override
    @NotNull
    public final File getFile() {
        return Objects.requireNonNull(this.file, "You have to load your class with '#load()' method");
    }

    @Override
    public final void addObject(@NotNull String key, @NotNull Object object) {
        this.objects.put(key, object);
    }

    @Override
    public final boolean isAutoSave() {
        return this.autosave;
    }

    @Override
    public final void setAutoSave(boolean autosv) {
        this.autosave = autosv;
    }

    @Override
    public final void autoSave() {
        if (this.autosave) {
            this.save();
        }
    }

    @Override
    public final void reloadIfShould() {
        if (this.lastreload < this.getFile().lastModified()) {
            try {
                this.getConfigurationSection().load(this.getFile());
                this.lastreload = System.currentTimeMillis();
            }
            catch (InvalidConfigurationException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @NotNull
    public final FileConfiguration getConfigurationSection() {
        return (FileConfiguration)super.getConfigurationSection();
    }
}

