/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.ConfigSection;
import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.configuration.ConfigurationSection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CfgSection {
    @NotNull
    public CfgSection getBase();

    @NotNull
    default public String getName() {
        return this.getConfigurationSection().getName();
    }

    @NotNull
    public ConfigurationSection getConfigurationSection();

    @NotNull
    default public Set<String> getKeys(boolean deep) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getKeys(deep);
    }

    @NotNull
    public FlManaged getManaged();

    @NotNull
    default public Optional<Object> get(@NotNull String path, @Nullable Object def) {
        this.getManaged().reloadIfShould();
        return Optional.ofNullable(this.getConfigurationSection().get(path, def));
    }

    @NotNull
    default public <T> T getOrSet(@NotNull String path, @NotNull T fallback) {
        this.getManaged().reloadIfShould();
        return (T)this.get(path).orElseGet(() -> {
            this.set(path, fallback);
            return fallback;
        });
    }

    @NotNull
    default public Optional<Object> get(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return Optional.ofNullable(this.getConfigurationSection().get(path));
    }

    default public void set(@NotNull String path, @Nullable Object object) {
        this.getConfigurationSection().set(path, object);
        this.getManaged().autoSave();
    }

    @NotNull
    default public CfgSection getOrCreateSection(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getSection(path).orElseGet(() -> this.createSection(path));
    }

    @NotNull
    default public Optional<CfgSection> getSection(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return Optional.ofNullable(this.getConfigurationSection().getConfigurationSection(path)).map(configurationsection -> {
            CfgSection configsection = this.getNewSection().get();
            configsection.setup(this.getManaged(), (ConfigurationSection)configurationsection);
            return configsection;
        });
    }

    @NotNull
    default public CfgSection createSection(@NotNull String path) {
        CfgSection configsection = this.getNewSection().get();
        configsection.setup(this.getManaged(), this.getConfigurationSection().createSection(path));
        this.getManaged().autoSave();
        return configsection;
    }

    @NotNull
    default public Supplier<CfgSection> getNewSection() {
        return ConfigSection::new;
    }

    public void setup(@NotNull FlManaged var1, @NotNull ConfigurationSection var2);

    @NotNull
    default public Optional<String> getString(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return Optional.ofNullable(this.getConfigurationSection().getString(path));
    }

    @NotNull
    default public Optional<String> getString(@NotNull String path, @Nullable String def) {
        this.getManaged().reloadIfShould();
        return Optional.ofNullable(this.getConfigurationSection().getString(path, def));
    }

    default public int getInt(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getInt(path);
    }

    default public int getInt(@NotNull String path, int def) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getInt(path, def);
    }

    default public boolean getBoolean(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getBoolean(path);
    }

    default public boolean getBoolean(@NotNull String path, boolean def) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getBoolean(path, def);
    }

    default public double getDouble(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getDouble(path);
    }

    default public double getDouble(@NotNull String path, double def) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getDouble(path, def);
    }

    default public long getLong(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getLong(path);
    }

    default public long getLong(@NotNull String path, long def) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getLong(path, def);
    }

    @NotNull
    default public List<String> getStringList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getStringList(path);
    }

    @NotNull
    default public List<Integer> getIntegerList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getIntegerList(path);
    }

    @NotNull
    default public List<Boolean> getBooleanList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getBooleanList(path);
    }

    @NotNull
    default public List<Double> getDoubleList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getDoubleList(path);
    }

    @NotNull
    default public List<Float> getFloatList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getFloatList(path);
    }

    @NotNull
    default public List<Long> getLongList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getLongList(path);
    }

    @NotNull
    default public List<Byte> getByteList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getByteList(path);
    }

    @NotNull
    default public List<Character> getCharacterList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getCharacterList(path);
    }

    @NotNull
    default public List<Short> getShortList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return this.getConfigurationSection().getShortList(path);
    }

    @NotNull
    default public Optional<List<?>> getList(@NotNull String path) {
        this.getManaged().reloadIfShould();
        return Optional.ofNullable(this.getConfigurationSection().getList(path));
    }
}

