/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.SkullUtils;
import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XPotion;
import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.potion.PotionEffect;

public class XItemStack {
    public static void serialize(ItemStack item, ConfigurationSection config) {
        Damageable damageable;
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            config.set("name", (Object)meta.getDisplayName());
        }
        if (item.getAmount() > 1) {
            config.set("amount", (Object)item.getAmount());
        }
        if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage()) {
            config.set("damage", (Object)damageable.getDamage());
        }
        config.set("material", (Object)item.getType());
        if (meta.hasCustomModelData()) {
            config.set("custom-model", (Object)meta.getCustomModelData());
        }
        if (meta.isUnbreakable()) {
            config.set("unbreakable", (Object)true);
        }
        if (meta.getItemFlags().size() != 0) {
            config.set("flags", (Object)meta.getItemFlags());
        }
        if (meta.hasAttributeModifiers()) {
            config.set("attributes", (Object)meta.getAttributeModifiers());
        }
        if (meta.hasLore()) {
            config.set("lore", (Object)meta.getLore());
        }
        if (meta.getEnchants().size() != 0) {
            config.set("enchants", (Object)meta.getEnchants());
        }
        if (XMaterial.supports(9) && meta.hasAttributeModifiers()) {
            config.set("attributes", (Object)meta.getAttributeModifiers());
        }
        if (meta instanceof SkullMeta) {
            config.set("skull", (Object)((SkullMeta)meta).getOwningPlayer().getUniqueId());
        } else if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            ArrayList<String> patterns = new ArrayList<String>();
            for (Pattern pattern : banner.getPatterns()) {
                patterns.add(pattern.getColor() + " " + pattern.getPattern().getIdentifier());
            }
            config.set("patterns", patterns);
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leather = (LeatherArmorMeta)meta;
            Color color = leather.getColor();
            config.set("color", (Object)(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue()));
        } else if (meta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            ArrayList<String> effects = new ArrayList<String>();
            for (PotionEffect effect : potion.getCustomEffects()) {
                effects.add(effect.getType().getName() + " " + effect.getDuration() + " " + effect.getAmplifier());
            }
            config.set("effects", effects);
        } else if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            config.set("power", (Object)firework.getPower());
            int i = 0;
            for (FireworkEffect fw : firework.getEffects()) {
                ConfigurationSection fwc = config.getConfigurationSection("firework." + i);
                fwc.set("type", (Object)fw.getType().name());
                ArrayList<String> colors = new ArrayList<String>();
                for (Color color : fw.getColors()) {
                    colors.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                fwc.set("colors", colors);
                colors.clear();
                for (Color color : fw.getFadeColors()) {
                    colors.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                fwc.set("fade-colors", colors);
            }
        } else if (XMaterial.supports(14)) {
            if (meta instanceof CrossbowMeta) {
                CrossbowMeta crossbow = (CrossbowMeta)meta;
                int i = 0;
                for (ItemStack projectiles : crossbow.getChargedProjectiles()) {
                    XItemStack.serialize(projectiles, config.getConfigurationSection("projectiles." + i));
                    ++i;
                }
            } else if (meta instanceof TropicalFishBucketMeta) {
                TropicalFishBucketMeta tropical = (TropicalFishBucketMeta)meta;
                config.set("pattern", (Object)tropical.getPattern().name());
                config.set("color", (Object)tropical.getBodyColor().name());
                config.set("pattern-color", (Object)tropical.getPatternColor().name());
            } else if (meta instanceof SuspiciousStewMeta) {
                SuspiciousStewMeta stew = (SuspiciousStewMeta)meta;
                ArrayList<String> effects = new ArrayList<String>();
                for (PotionEffect effect : stew.getCustomEffects()) {
                    effects.add(effect.getType().getName() + " " + effect.getDuration() + " " + effect.getAmplifier());
                }
                config.set("effects", effects);
            }
        }
    }

    public static ItemStack deserialize(ConfigurationSection config) {
        ConfigurationSection attributes;
        List lores;
        int modelData;
        PotionEffect effect;
        int damage;
        String material = config.getString("material");
        if (material == null) {
            return null;
        }
        Optional<XMaterial> matOpt = XMaterial.matchXMaterial(material);
        if (!matOpt.isPresent()) {
            return null;
        }
        ItemStack item = matOpt.get().parseItem();
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        int amount = config.getInt("amount");
        if (amount > 1) {
            item.setAmount(amount);
        }
        if (XMaterial.isNewVersion()) {
            if (meta instanceof Damageable && (damage = config.getInt("damage")) > 0) {
                ((Damageable)meta).setDamage(damage);
            }
        } else {
            damage = config.getInt("damage");
            if (damage > 1) {
                item.setDurability((short)damage);
            }
        }
        if (item.getType() == XMaterial.PLAYER_HEAD.parseMaterial()) {
            String skull = config.getString("skull");
            if (skull != null) {
                SkullUtils.applySkin(meta, skull);
            }
        } else if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            for (String pattern : config.getStringList("patterns")) {
                PatternType type;
                String[] split = pattern.split("  +");
                if (split.length == 0) continue;
                DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)split[0]).or((Object)DyeColor.WHITE);
                if (split.length > 1) {
                    type = PatternType.getByIdentifier((String)split[1]);
                    if (type == null) {
                        type = (PatternType)Enums.getIfPresent(PatternType.class, (String)split[1]).or((Object)PatternType.BASE);
                    }
                } else {
                    type = PatternType.BASE;
                }
                banner.addPattern(new Pattern(color, type));
            }
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leather = (LeatherArmorMeta)meta;
            String colorStr = config.getString("color");
            if (colorStr != null) {
                leather.setColor(XItemStack.parseColor(colorStr));
            }
        } else if (meta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            for (Object effects : config.getStringList("effects")) {
                effect = XPotion.parsePotionEffectFromString((String)effects);
                potion.addCustomEffect(effect, true);
            }
        } else if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            FireworkEffect.Builder builder = FireworkEffect.builder();
            for (String fws : config.getConfigurationSection("fireworks").getKeys(false)) {
                ConfigurationSection fw = config.getConfigurationSection("firework." + fws);
                firework.setPower(fw.getInt("power"));
                builder.flicker(fw.getBoolean("flicker"));
                builder.trail(fw.getBoolean("trail"));
                builder.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)fw.getString("type")).or((Object)FireworkEffect.Type.STAR));
                ArrayList<Color> colors = new ArrayList<Color>();
                for (String colorStr : fw.getStringList("colors")) {
                    colors.add(XItemStack.parseColor(colorStr));
                }
                builder.withColor(colors);
                colors.clear();
                for (String colorStr : fw.getStringList("fade-colors")) {
                    colors.add(XItemStack.parseColor(colorStr));
                }
                builder.withFade(colors);
                firework.addEffect(builder.build());
            }
        } else if (XMaterial.supports(14)) {
            if (meta instanceof CrossbowMeta) {
                CrossbowMeta crossbow = (CrossbowMeta)meta;
                for (String projectiles : config.getConfigurationSection("projectiles").getKeys(false)) {
                    ItemStack projectile = XItemStack.deserialize(config.getConfigurationSection("projectiles." + projectiles));
                    crossbow.addChargedProjectile(projectile);
                }
            } else if (meta instanceof TropicalFishBucketMeta) {
                TropicalFishBucketMeta tropical = (TropicalFishBucketMeta)meta;
                DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.WHITE);
                DyeColor patternColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("pattern-color")).or((Object)DyeColor.WHITE);
                TropicalFish.Pattern pattern = (TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)config.getString("pattern")).or((Object)TropicalFish.Pattern.BETTY);
                tropical.setBodyColor(color);
                tropical.setPatternColor(patternColor);
                tropical.setPattern(pattern);
            } else if (meta instanceof SuspiciousStewMeta) {
                SuspiciousStewMeta stew = (SuspiciousStewMeta)meta;
                for (Object effects : config.getStringList("effects")) {
                    effect = XPotion.parsePotionEffectFromString((String)effects);
                    stew.addCustomEffect(effect, true);
                }
            }
        }
        String name = config.getString("name");
        if (name != null) {
            if (name.isEmpty()) {
                name = " ";
            }
            String translated = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            meta.setDisplayName(translated);
        }
        if (XMaterial.supports(11)) {
            meta.setUnbreakable(config.getBoolean("unbreakable"));
        }
        if (XMaterial.supports(14) && (modelData = config.getInt("model-data")) != 0) {
            meta.setCustomModelData(Integer.valueOf(modelData));
        }
        if (!(lores = config.getStringList("lore")).isEmpty()) {
            ArrayList<String> translatedLore = new ArrayList<String>();
            Object lastColors = "";
            for (String lore : lores) {
                if (lore.isEmpty()) {
                    translatedLore.add(" ");
                    continue;
                }
                for (String singleLore : StringUtils.splitPreserveAllTokens((String)lore, (char)'\n')) {
                    if (singleLore.isEmpty()) {
                        translatedLore.add(" ");
                        continue;
                    }
                    singleLore = (String)lastColors + ChatColor.translateAlternateColorCodes((char)'&', (String)singleLore);
                    translatedLore.add(singleLore);
                    lastColors = ChatColor.getLastColors((String)singleLore);
                }
            }
            meta.setLore(translatedLore);
        }
        List enchants = config.getStringList("enchants");
        for (Object ench : enchants) {
            String[] parseEnchant = StringUtils.split((String)StringUtils.deleteWhitespace((String)ench), (char)',');
            Optional<XEnchantment> enchant = XEnchantment.matchXEnchantment(parseEnchant[0]);
            if (!enchant.isPresent()) continue;
            int lvl = parseEnchant.length > 1 ? Integer.parseInt(parseEnchant[1]) : 1;
            meta.addEnchant(enchant.get().parseEnchantment(), lvl, false);
        }
        List flags = config.getStringList("flags");
        for (String flag : flags) {
            if (flag.equalsIgnoreCase("all")) {
                meta.addItemFlags(ItemFlag.values());
                break;
            }
            ItemFlag itemFlag = ItemFlag.valueOf((String)flag.toUpperCase());
            meta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        if (XMaterial.supports(9) && (attributes = config.getConfigurationSection("attributes")) != null) {
            for (String attribute : attributes.getKeys(false)) {
                AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), attributes.getString("generic"), (double)attributes.getInt("amount"), (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attributes.getString("operation")).or((Object)AttributeModifier.Operation.ADD_NUMBER), (EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)attributes.getString("slot")).or((Object)EquipmentSlot.HAND));
                meta.addAttributeModifier(Attribute.valueOf((String)attribute), modifier);
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static Color parseColor(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return Color.BLACK;
        }
        String[] rgb = StringUtils.split((String)StringUtils.deleteWhitespace((String)str), (char)',');
        return Color.fromRGB((int)NumberUtils.toInt((String)rgb[0], (int)0), (int)NumberUtils.toInt((String)rgb[1], (int)0), (int)NumberUtils.toInt((String)rgb[1], (int)0));
    }
}

