/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.XItemStack;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XPotion;
import com.google.common.base.Enums;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Cat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class XEntity {
    public static Entity spawn(Location location, ConfigurationSection config) {
        int portalCooldown;
        String typeStr = config.getString("type");
        if (typeStr == null) {
            return null;
        }
        EntityType type = (EntityType)Enums.getIfPresent(EntityType.class, (String)typeStr.toUpperCase(Locale.ENGLISH)).or((Object)EntityType.ZOMBIE);
        Entity entity = location.getWorld().spawnEntity(location, type);
        String name = config.getString("name");
        if (name != null) {
            entity.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            entity.setCustomNameVisible(true);
        }
        if (config.isSet("glowing")) {
            entity.setGlowing(config.getBoolean("glowing"));
        }
        if (config.isSet("gravity")) {
            entity.setGravity(config.getBoolean("gravity"));
        }
        if (config.isSet("silent")) {
            entity.setSilent(config.getBoolean("silent"));
        }
        entity.setFireTicks(config.getInt("fire-ticks"));
        entity.setFallDistance((float)config.getInt("fall-distance"));
        entity.setInvulnerable(config.getBoolean("invulnerable"));
        int live = config.getInt("ticks-lived");
        if (live > 0) {
            entity.setTicksLived(live);
        }
        if ((portalCooldown = config.getInt("portal-cooldown", -1)) != -1) {
            entity.setPortalCooldown(portalCooldown);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            double hp = config.getDouble("health", -1.0);
            if (hp > -1.0) {
                living.setHealth(hp);
            }
            living.setAbsorptionAmount((double)config.getInt("absorption"));
            if (config.isSet("AI")) {
                living.setAI(config.getBoolean("AI"));
            }
            if (config.isSet("can-pickup-items")) {
                living.setCanPickupItems(config.getBoolean("can-pickup-items"));
            }
            if (config.isSet("collidable")) {
                living.setCollidable(config.getBoolean("collidable"));
            }
            if (config.isSet("gliding")) {
                living.setGliding(config.getBoolean("gliding"));
            }
            if (config.isSet("remove-when-far-away")) {
                living.setRemoveWhenFarAway(config.getBoolean("remove-when-far-away"));
            }
            if (config.isSet("swimming")) {
                living.setSwimming(config.getBoolean("swimming"));
            }
            living.setMaximumAir(config.getInt("max-air"));
            living.setNoDamageTicks(config.getInt("do-damage-ticks"));
            living.setRemainingAir(config.getInt("remaining-air"));
            for (String effects : config.getStringList("effects")) {
                living.addPotionEffect(XPotion.parsePotionEffectFromString(effects));
            }
            ConfigurationSection equip = config.getConfigurationSection("equipment");
            if (equip != null) {
                ConfigurationSection offHand;
                ConfigurationSection mainHand;
                ConfigurationSection boots;
                ConfigurationSection leggings;
                Object chestplate;
                EntityEquipment equipment = living.getEquipment();
                ConfigurationSection helment = equip.getConfigurationSection("helment");
                if (helment != null) {
                    equipment.setHelmet(XItemStack.deserialize(helment.getConfigurationSection("item")));
                    equipment.setHelmetDropChance((float)helment.getInt("drop-chance"));
                }
                if ((chestplate = equip.getConfigurationSection("chestplate")) != null) {
                    equipment.setChestplate(XItemStack.deserialize(chestplate.getConfigurationSection("item")));
                    equipment.setChestplateDropChance((float)chestplate.getInt("drop-chance"));
                }
                if ((leggings = equip.getConfigurationSection("leggings")) != null) {
                    equipment.setLeggings(XItemStack.deserialize(leggings.getConfigurationSection("item")));
                    equipment.setLeggingsDropChance((float)leggings.getInt("drop-chance"));
                }
                if ((boots = equip.getConfigurationSection("boots")) != null) {
                    equipment.setBoots(XItemStack.deserialize(boots.getConfigurationSection("item")));
                    equipment.setBootsDropChance((float)boots.getInt("drop-chance"));
                }
                if ((mainHand = equip.getConfigurationSection("main-hand")) != null) {
                    equipment.setItemInMainHand(XItemStack.deserialize(mainHand.getConfigurationSection("item")));
                    equipment.setItemInMainHandDropChance((float)mainHand.getInt("drop-chance"));
                }
                if ((offHand = equip.getConfigurationSection("off-hand")) != null) {
                    equipment.setItemInOffHand(XItemStack.deserialize(offHand.getConfigurationSection("item")));
                    equipment.setItemInOffHandDropChance((float)offHand.getInt("drop-chance"));
                }
            }
            if (living instanceof Ageable) {
                int age;
                Ageable ageable = (Ageable)living;
                if (config.isSet("breed")) {
                    ageable.setBreed(config.getBoolean("breed"));
                }
                if (config.isSet("baby")) {
                    if (config.getBoolean("baby")) {
                        ageable.setBaby();
                    } else {
                        ageable.setAdult();
                    }
                }
                if ((age = config.getInt("age", 0)) > 0) {
                    ageable.setAge(age);
                }
                if (config.isSet("age-lock")) {
                    ageable.setAgeLock(config.getBoolean("age-lock"));
                }
            }
            if (living instanceof Tameable) {
                Tameable tam = (Tameable)living;
                tam.setTamed(config.getBoolean("tamed"));
            }
            if (living instanceof Sittable) {
                Sittable sit = (Sittable)living;
                sit.setSitting(config.getBoolean("sitting"));
            }
            if (living instanceof Spellcaster) {
                Spellcaster caster = (Spellcaster)living;
                caster.setSpell((Spellcaster.Spell)Enums.getIfPresent(Spellcaster.Spell.class, (String)config.getString("spell")).or((Object)Spellcaster.Spell.NONE));
            }
            if (living instanceof ChestedHorse) {
                ChestedHorse chested = (ChestedHorse)living;
                chested.setCarryingChest(config.getBoolean("has-chest"));
                ConfigurationSection items = config.getConfigurationSection("items");
                if (items != null) {
                    for (String key : items.getKeys(false)) {
                        ItemStack item;
                        ConfigurationSection itemSec = items.getConfigurationSection(key);
                        int slot = itemSec.getInt("slot", -1);
                        if (slot == -1 || (item = XItemStack.deserialize(itemSec)) == null) continue;
                        chested.getInventory().setItem(slot, item);
                    }
                }
            }
            if (living instanceof Enderman) {
                ItemStack item;
                Optional<XMaterial> mat;
                Enderman enderman = (Enderman)living;
                String block = config.getString("block");
                if (block != null && (mat = XMaterial.matchXMaterial(block)).isPresent() && (item = mat.get().parseItem()) != null) {
                    enderman.setCarriedMaterial(item.getData());
                }
            } else if (living instanceof Rabbit) {
                Rabbit rabbit = (Rabbit)living;
                rabbit.setRabbitType((Rabbit.Type)Enums.getIfPresent(Rabbit.Type.class, (String)config.getString("rabbit-type")).or((Object)Rabbit.Type.WHITE));
            } else if (living instanceof Bat) {
                Bat bat = (Bat)living;
                if (!config.getBoolean("awake")) {
                    bat.setAwake(false);
                }
            } else if (living instanceof Cat) {
                Cat cat = (Cat)living;
                cat.setCatType((Cat.Type)Enums.getIfPresent(Cat.Type.class, (String)config.getString("cat-type")).or((Object)Cat.Type.TABBY));
                cat.setCollarColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.GREEN));
            } else if (living instanceof Wolf) {
                Wolf wolf = (Wolf)living;
                wolf.setAngry(config.getBoolean("angry"));
                wolf.setCollarColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.GREEN));
            } else if (living instanceof Creeper) {
                Creeper creeper = (Creeper)living;
                creeper.setExplosionRadius(config.getInt("explosion-radius"));
                creeper.setMaxFuseTicks(config.getInt("max-fuse-ticks"));
                creeper.setPowered(config.getBoolean("powered"));
            } else if (XMaterial.supports(10)) {
                if (living instanceof Husk) {
                    Husk husk = (Husk)living;
                    husk.setConversionTime(config.getInt("conversion-time"));
                } else if (XMaterial.supports(11)) {
                    if (living instanceof Vex) {
                        Vex vex = (Vex)living;
                        vex.setCharging(config.getBoolean("charging"));
                    } else if (living instanceof Llama) {
                        Llama llama = (Llama)living;
                        llama.setColor((Llama.Color)Enums.getIfPresent(Llama.Color.class, (String)config.getString("color")).or((Object)Llama.Color.WHITE));
                        llama.setStrength(config.getInt("strength"));
                    } else if (XMaterial.supports(12)) {
                        if (living instanceof Parrot) {
                            Parrot parrot = (Parrot)living;
                            parrot.setVariant((Parrot.Variant)Enums.getIfPresent(Parrot.Variant.class, (String)config.getString("variant")).or((Object)Parrot.Variant.RED));
                        } else if (XMaterial.isNewVersion()) {
                            if (living instanceof PufferFish) {
                                PufferFish pufferFish = (PufferFish)living;
                                pufferFish.setPuffState(config.getInt("puff-state"));
                            } else if (living instanceof TropicalFish) {
                                TropicalFish tropicalFish = (TropicalFish)living;
                                tropicalFish.setBodyColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.WHITE));
                                tropicalFish.setPattern((TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)config.getString("pattern")).or((Object)TropicalFish.Pattern.BETTY));
                                tropicalFish.setPatternColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("pattern-color")).or((Object)DyeColor.WHITE));
                            } else if (living instanceof EnderDragon) {
                                EnderDragon dragon = (EnderDragon)living;
                                dragon.setPhase((EnderDragon.Phase)Enums.getIfPresent(EnderDragon.Phase.class, (String)config.getString("phase")).or((Object)EnderDragon.Phase.ROAR_BEFORE_ATTACK));
                            } else if (living instanceof Phantom) {
                                Phantom phantom = (Phantom)living;
                                phantom.setSize(config.getInt("size"));
                            } else if (living instanceof Fox) {
                                Fox fox = (Fox)living;
                                fox.setCrouching(config.getBoolean("crouching"));
                                fox.setSleeping(config.getBoolean("sleeping"));
                                fox.setFoxType((Fox.Type)Enums.getIfPresent(Fox.Type.class, (String)config.getString("type")).or((Object)Fox.Type.RED));
                            } else if (XMaterial.supports(14)) {
                                if (living instanceof Panda) {
                                    Panda panda = (Panda)living;
                                    panda.setHiddenGene((Panda.Gene)Enums.getIfPresent(Panda.Gene.class, (String)config.getString("hidden-gene")).or((Object)Panda.Gene.PLAYFUL));
                                    panda.setMainGene((Panda.Gene)Enums.getIfPresent(Panda.Gene.class, (String)config.getString("main-gene")).or((Object)Panda.Gene.NORMAL));
                                } else if (living instanceof MushroomCow) {
                                    MushroomCow mooshroom = (MushroomCow)living;
                                    mooshroom.setVariant((MushroomCow.Variant)Enums.getIfPresent(MushroomCow.Variant.class, (String)config.getString("variant")).or((Object)MushroomCow.Variant.RED));
                                } else if (XMaterial.supports(15) && living instanceof Bee) {
                                    Bee bee = (Bee)living;
                                    bee.setAnger(config.getInt("anger"));
                                    bee.setHasNectar(config.getBoolean("nectar"));
                                    bee.setHasStung(config.getBoolean("stung"));
                                }
                            }
                        }
                    }
                }
            }
        } else if (entity instanceof EnderSignal) {
            EnderSignal signal = (EnderSignal)entity;
            signal.setDespawnTimer(config.getInt("despawn-timer"));
            signal.setDropItem(config.getBoolean("drop-item"));
        } else if (entity instanceof ExperienceOrb) {
            ExperienceOrb orb = (ExperienceOrb)entity;
            orb.setExperience(config.getInt("exp"));
        } else if (entity instanceof Explosive) {
            Explosive explosive = (Explosive)entity;
            explosive.setIsIncendiary(config.getBoolean("incendiary"));
        } else if (entity instanceof EnderCrystal) {
            EnderCrystal crystal = (EnderCrystal)entity;
            crystal.setShowingBottom(config.getBoolean("show-bottom"));
        }
        return entity;
    }
}

