/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.XMaterial;
import java.util.EnumSet;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.Cake;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.material.Colorable;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Wood;
import org.bukkit.material.Wool;

public final class XBlock {
    public static final EnumSet<XMaterial> CROPS = EnumSet.of(XMaterial.CARROT, new XMaterial[]{XMaterial.POTATO, XMaterial.NETHER_WART, XMaterial.WHEAT_SEEDS, XMaterial.PUMPKIN_SEEDS, XMaterial.MELON_SEEDS, XMaterial.BEETROOT_SEEDS, XMaterial.SUGAR_CANE, XMaterial.BAMBOO_SAPLING, XMaterial.CHORUS_PLANT, XMaterial.KELP, XMaterial.SEA_PICKLE, XMaterial.BROWN_MUSHROOM, XMaterial.RED_MUSHROOM});
    public static final EnumSet<XMaterial> DANGEROUS = EnumSet.of(XMaterial.MAGMA_BLOCK, XMaterial.LAVA, XMaterial.CAMPFIRE, XMaterial.FIRE);
    public static final int CAKE_SLICES = 6;
    private static final boolean ISFLAT = XMaterial.isNewVersion();

    public static boolean isLit(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Lightable)) {
                return false;
            }
            Lightable lightable = (Lightable)block.getBlockData();
            return lightable.isLit();
        }
        return XBlock.isMaterial(block, "REDSTONE_LAMP_ON", "REDSTONE_TORCH_ON", "BURNING_FURNACE");
    }

    public static boolean isContainer(Block block) {
        return block.getState() instanceof InventoryHolder;
    }

    public static void setLit(Block block, boolean lit) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Lightable)) {
                return;
            }
            Lightable lightable = (Lightable)block.getBlockData();
            lightable.setLit(lit);
            return;
        }
        String name = block.getType().name();
        if (name.endsWith("FURNACE")) {
            block.setType(Material.getMaterial((String)"BURNING_FURNACE"));
        } else if (name.startsWith("REDSTONE_LAMP")) {
            block.setType(Material.getMaterial((String)"REDSTONE_LAMP_ON"));
        } else {
            block.setType(Material.getMaterial((String)"REDSTONE_TORCH_ON"));
        }
    }

    public static boolean isCrops(Material material) {
        return CROPS.contains((Object)XMaterial.matchXMaterial(material));
    }

    public static boolean isDangerous(Block block) {
        return DANGEROUS.contains((Object)XMaterial.matchXMaterial(block.getType()));
    }

    public static DyeColor getColor(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Colorable)) {
                return null;
            }
            Colorable colorable = (Colorable)block.getBlockData();
            return colorable.getColor();
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Wool) {
            Wool wool = (Wool)data;
            return wool.getColor();
        }
        return null;
    }

    public static boolean isCake(Material material) {
        return ISFLAT ? material == Material.CAKE : material.name().equals("CAKE_BLOCK");
    }

    public static boolean isWheat(Material material) {
        return ISFLAT ? material == Material.WHEAT : material.name().equals("CROPS");
    }

    public static boolean isSugarCane(Material material) {
        return ISFLAT ? material == Material.SUGAR_CANE : material.name().equals("SUGAR_CANE_BLOCK");
    }

    public static boolean isBeetroot(Material material) {
        return ISFLAT ? material == Material.SUGAR_CANE : material.name().equals("BEETROOT_BLOCK");
    }

    public static boolean isNetherWart(Material material) {
        return ISFLAT ? material == Material.NETHER_WART : material.name().equals("NETHER_WARTS");
    }

    public static boolean isCarrot(Material material) {
        return ISFLAT ? material.name().equals("CARROTS") : material == Material.CARROT;
    }

    public static boolean isPotato(Material material) {
        return ISFLAT ? material.name().equals("POTATOES") : material == Material.POTATO;
    }

    public static BlockFace getDirection(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof org.bukkit.block.data.Directional)) {
                return BlockFace.SELF;
            }
            org.bukkit.block.data.Directional direction = (org.bukkit.block.data.Directional)block.getBlockData();
            return direction.getFacing();
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Directional) {
            return ((Directional)data).getFacing();
        }
        return null;
    }

    public static boolean setDirection(Block block, BlockFace facing) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof org.bukkit.block.data.Directional)) {
                return false;
            }
            org.bukkit.block.data.Directional direction = (org.bukkit.block.data.Directional)block.getBlockData();
            direction.setFacing(facing);
            return true;
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Directional) {
            ((Directional)data).setFacingDirection(facing);
            state.update(true);
            return true;
        }
        return false;
    }

    public static int getAge(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Ageable)) {
                return 0;
            }
            Ageable ageable = (Ageable)block.getBlockData();
            return ageable.getAge();
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        return data.getData();
    }

    public static void setAge(Block block, int age) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Ageable)) {
                return;
            }
            Ageable ageable = (Ageable)block.getBlockData();
            ageable.setAge(age);
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        data.setData((byte)age);
        state.update(true);
    }

    public static boolean setColor(Block block, DyeColor color) {
        if (ISFLAT) {
            String type = block.getType().name();
            if (type.endsWith("WOOL")) {
                block.setType(Material.getMaterial((String)(color.name() + "_WOOL")));
            } else if (type.endsWith("BED")) {
                block.setType(Material.getMaterial((String)(color.name() + "_BED")));
            } else if (type.endsWith("STAINED_GLASS")) {
                block.setType(Material.getMaterial((String)(color.name() + "_STAINED_GLASS")));
            } else if (type.endsWith("STAINED_GLASS_PANE")) {
                block.setType(Material.getMaterial((String)(color.name() + "_STAINED_GLASS_PANE")));
            } else if (type.endsWith("TERRACOTTA")) {
                block.setType(Material.getMaterial((String)(color.name() + "_TERRACOTTA")));
            } else if (type.endsWith("GLAZED_TERRACOTTA")) {
                block.setType(Material.getMaterial((String)(color.name() + "_GLAZED_TERRACOTTA")));
            } else if (type.endsWith("BANNER")) {
                block.setType(Material.getMaterial((String)(color.name() + "_BANNER")));
            } else if (type.endsWith("WALL_BANNER")) {
                block.setType(Material.getMaterial((String)(color.name() + "_WALL_BANNER")));
            } else if (type.endsWith("CARPET")) {
                block.setType(Material.getMaterial((String)(color.name() + "_CARPET")));
            } else if (type.endsWith("SHULKER_BOX")) {
                block.setType(Material.getMaterial((String)(color.name() + "_SHULKERBOX")));
            } else if (type.endsWith("CONCRETE")) {
                block.setType(Material.getMaterial((String)(color.name() + "_CONCRETE")));
            } else if (type.endsWith("CONCRETE_POWDER")) {
                block.setType(Material.getMaterial((String)(color.name() + "_CONCRETE_POWDER")));
            } else {
                return false;
            }
            return true;
        }
        BlockState state = block.getState();
        state.setRawData(color.getWoolData());
        state.update(true);
        return false;
    }

    public static boolean setFluidLevel(Block block, int level) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Levelled)) {
                return false;
            }
            Levelled levelled = (Levelled)block.getBlockData();
            levelled.setLevel(level);
            return true;
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        data.setData((byte)level);
        state.update(true);
        return false;
    }

    public static int getFluidLevel(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Levelled)) {
                return -1;
            }
            Levelled levelled = (Levelled)block.getBlockData();
            return levelled.getLevel();
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        return data.getData();
    }

    public static boolean isWaterStationary(Block block) {
        return ISFLAT ? XBlock.getFluidLevel(block) < 7 : block.getType().name().equals("STATIONARY_WATER");
    }

    public static boolean isWater(Material material) {
        String name = material.name();
        return name.equals("WATER") || name.equals("STATIONARY_WATER");
    }

    public static boolean isOneOf(Block block, List<String> blocks) {
        return XMaterial.isOneOf(block.getType(), blocks);
    }

    public static void setCakeSlices(Block block, int amount) {
        if (!XBlock.isCake(block.getType())) {
            throw new IllegalArgumentException("Block is not a cake: " + block.getType());
        }
        if (ISFLAT) {
            BlockData bd = block.getBlockData();
            if (bd instanceof Cake) {
                Cake cake = (Cake)bd;
                if (amount > cake.getMaximumBites()) {
                    block.breakNaturally();
                    return;
                }
                cake.setBites(cake.getBites() + 1);
                block.setBlockData(bd);
            }
            return;
        }
        BlockState state = block.getState();
        if (state instanceof org.bukkit.material.Cake) {
            org.bukkit.material.Cake cake = (org.bukkit.material.Cake)state.getData();
            if (amount > 1) {
                block.breakNaturally();
                return;
            }
            cake.setSlicesRemaining(amount);
            state.update();
        }
    }

    public static int addCakeSlices(Block block, int slices) {
        if (!XBlock.isCake(block.getType())) {
            throw new IllegalArgumentException("Block is not a cake: " + block.getType());
        }
        if (ISFLAT) {
            BlockData bd = block.getBlockData();
            Cake cake = (Cake)bd;
            if (cake.getBites() + slices > cake.getMaximumBites()) {
                block.breakNaturally();
                return cake.getMaximumBites() - cake.getBites();
            }
            cake.setBites(cake.getBites() + slices);
            block.setBlockData(bd);
            return cake.getMaximumBites() - cake.getBites();
        }
        BlockState state = block.getState();
        org.bukkit.material.Cake cake = (org.bukkit.material.Cake)state.getData();
        if (cake.getSlicesEaten() + slices >= 6) {
            block.breakNaturally();
            return cake.getSlicesRemaining();
        }
        cake.setSlicesEaten(cake.getSlicesEaten() + slices);
        state.update();
        return cake.getSlicesRemaining();
    }

    public static boolean setWooden(Block block, XMaterial species) {
        block.setType(species.parseMaterial());
        if (ISFLAT) {
            return true;
        }
        TreeSpecies type = species == XMaterial.SPRUCE_LOG ? TreeSpecies.REDWOOD : TreeSpecies.valueOf((String)species.name().substring(0, species.name().indexOf(95)));
        BlockState state = block.getState();
        MaterialData data = state.getData();
        ((Wood)data).setSpecies(type);
        state.update(true);
        return true;
    }

    public static boolean isType(Block block, XMaterial material) {
        Material mat = block.getType();
        switch (material) {
            case CAKE: {
                return XBlock.isCake(mat);
            }
            case NETHER_WART: {
                return XBlock.isNetherWart(mat);
            }
            case CARROT: 
            case CARROTS: {
                return XBlock.isCarrot(mat);
            }
            case POTATO: 
            case POTATOES: {
                return XBlock.isPotato(mat);
            }
            case WHEAT: 
            case WHEAT_SEEDS: {
                return XBlock.isWheat(mat);
            }
            case BEETROOT: 
            case BEETROOT_SEEDS: 
            case BEETROOTS: {
                return XBlock.isBeetroot(mat);
            }
            case SUGAR_CANE: {
                return XBlock.isSugarCane(mat);
            }
            case WATER: {
                return XBlock.isWater(mat);
            }
            case AIR: {
                return XBlock.isAir(mat);
            }
        }
        return false;
    }

    public static boolean isAir(Material material) {
        return material.name().endsWith("IR");
    }

    public static boolean isPowered(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Powerable)) {
                return false;
            }
            Powerable powerable = (Powerable)block.getBlockData();
            return powerable.isPowered();
        }
        String name = block.getType().name();
        if (name.startsWith("REDSTONE_COMPARATOR")) {
            return XBlock.isMaterial(block, "REDSTONE_COMPARATOR_ON");
        }
        return false;
    }

    public static void setPowered(Block block, boolean powered) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Powerable)) {
                return;
            }
            Powerable powerable = (Powerable)block.getBlockData();
            powerable.setPowered(powered);
            return;
        }
        String name = block.getType().name();
        if (name.startsWith("REDSTONE_COMPARATOR")) {
            block.setType(Material.getMaterial((String)"REDSTONE_COMPARATOR_ON"));
        }
    }

    public static boolean isOpen(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Openable)) {
                return false;
            }
            Openable openable = (Openable)block.getBlockData();
            return openable.isOpen();
        }
        BlockState state = block.getState();
        if (!(state instanceof org.bukkit.material.Openable)) {
            return false;
        }
        org.bukkit.material.Openable openable = (org.bukkit.material.Openable)state.getData();
        return openable.isOpen();
    }

    public static void setOpened(Block block, boolean opened) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Openable)) {
                return;
            }
            Openable openable = (Openable)block.getBlockData();
            openable.setOpen(opened);
            return;
        }
        BlockState state = block.getState();
        if (!(state instanceof org.bukkit.material.Openable)) {
            return;
        }
        org.bukkit.material.Openable openable = (org.bukkit.material.Openable)state.getData();
        openable.setOpen(opened);
        state.setData((MaterialData)openable);
        state.update();
    }

    public static BlockFace getRotation(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Rotatable)) {
                return null;
            }
            Rotatable rotatable = (Rotatable)block.getBlockData();
            return rotatable.getRotation();
        }
        return null;
    }

    public static void setRotation(Block block, BlockFace facing) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Rotatable)) {
                return;
            }
            Rotatable rotatable = (Rotatable)block.getBlockData();
            rotatable.setRotation(facing);
        }
    }

    private static boolean isMaterial(Block block, String ... materials) {
        String type = block.getType().name();
        for (String material : materials) {
            if (!type.equals(material)) continue;
            return true;
        }
        return false;
    }
}

