/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.google.common.base.Enums;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;

public enum XBiome {
    BADLANDS("MESA"),
    BADLANDS_PLATEAU("MESA_CLEAR_ROCK", "MESA_PLATEAU"),
    BEACH("BEACHES"),
    BIRCH_FOREST("BIRCH_FOREST"),
    BIRCH_FOREST_HILLS("BIRCH_FOREST_HILLS"),
    COLD_OCEAN("COLD_OCEAN"),
    DARK_FOREST("ROOFED_FOREST"),
    DARK_FOREST_HILLS("MUTATED_ROOFED_FOREST", "ROOFED_FOREST_MOUNTAINS"),
    DEEP_COLD_OCEAN("COLD_DEEP_OCEAN"),
    DEEP_FROZEN_OCEAN("FROZEN_DEEP_OCEAN"),
    DEEP_LUKEWARM_OCEAN("LUKEWARM_DEEP_OCEAN"),
    DEEP_OCEAN("DEEP_OCEAN"),
    DEEP_WARM_OCEAN("WARM_DEEP_OCEAN"),
    DESERT("DESERT"),
    DESERT_HILLS("DESERT_HILLS"),
    DESERT_LAKES("MUTATED_DESERT", "DESERT_MOUNTAINS"),
    END_BARRENS("SKY_ISLAND_BARREN"),
    END_HIGHLANDS("SKY_ISLAND_HIGH"),
    END_MIDLANDS("SKY_ISLAND_MEDIUM"),
    ERODED_BADLANDS("MUTATED_MESA", "MESA_BRYCE"),
    FLOWER_FOREST("MUTATED_FOREST"),
    FOREST("FOREST"),
    FROZEN_OCEAN("FROZEN_OCEAN"),
    FROZEN_RIVER("FROZEN_RIVER"),
    GIANT_SPRUCE_TAIGA("MUTATED_REDWOOD_TAIGA", "MEGA_SPRUCE_TAIGA"),
    GIANT_SPRUCE_TAIGA_HILLS("MUTATED_REDWOOD_TAIGA_HILLS", "MEGA_SPRUCE_TAIGA_HILLS"),
    GIANT_TREE_TAIGA("REDWOOD_TAIGA", "MEGA_TAIGA"),
    GIANT_TREE_TAIGA_HILLS("REDWOOD_TAIGA_HILLS", "MEGA_TAIGA_HILLS"),
    GRAVELLY_MOUNTAINS("MUTATED_EXTREME_HILLS", "EXTREME_HILLS_MOUNTAINS"),
    ICE_SPIKES("MUTATED_ICE_FLATS", "ICE_PLAINS_SPIKES"),
    JUNGLE("JUNGLE"),
    JUNGLE_EDGE("JUNGLE_EDGE"),
    JUNGLE_HILLS("JUNGLE_HILLS"),
    LUKEWARM_OCEAN("LUKEWARM_OCEAN"),
    MODIFIED_BADLANDS_PLATEAU("MUTATED_MESA_CLEAR_ROCK", "MESA_PLATEAU"),
    MODIFIED_GRAVELLY_MOUNTAINS("MUTATED_EXTREME_HILLS_WITH_TREES", "EXTREME_HILLS_MOUNTAINS"),
    MODIFIED_JUNGLE("MUTATED_JUNGLE", "JUNGLE_MOUNTAINS"),
    MODIFIED_JUNGLE_EDGE("MUTATED_JUNGLE_EDGE", "JUNGLE_EDGE_MOUNTAINS"),
    MODIFIED_WOODED_BADLANDS_PLATEAU("MUTATED_MESA_ROCK", "MESA_PLATEAU_FOREST_MOUNTAINS"),
    MOUNTAINS("EXTREME_HILLS"),
    MOUNTAIN_EDGE("SMALLER_EXTREME_HILLS"),
    MUSHROOM_FIELDS("MUSHROOM_ISLAND"),
    MUSHROOM_FIELD_SHORE("MUSHROOM_ISLAND_SHORE", "MUSHROOM_SHORE"),
    NETHER("HELL"),
    OCEAN("OCEAN"),
    PLAINS("PLAINS"),
    RIVER("RIVER"),
    SAVANNA("SAVANNA"),
    SAVANNA_PLATEAU("SAVANNA_ROCK", "SAVANNA_PLATEAU"),
    SHATTERED_SAVANNA("MUTATED_SAVANNA", "SAVANNA_MOUNTAINS"),
    SHATTERED_SAVANNA_PLATEAU("MUTATED_SAVANNA_ROCK", "SAVANNA_PLATEAU_MOUNTAINS"),
    SMALL_END_ISLANDS("SKY_ISLAND_LOW"),
    SNOWY_BEACH("COLD_BEACH"),
    SNOWY_MOUNTAINS("ICE_MOUNTAINS"),
    SNOWY_TAIGA("TAIGA_COLD", "COLD_TAIGA"),
    SNOWY_TAIGA_HILLS("TAIGA_COLD_HILLS", "COLD_TAIGA_HILLS"),
    SNOWY_TAIGA_MOUNTAINS("MUTATED_TAIGA_COLD", "COLD_TAIGA_MOUNTAINS"),
    SNOWY_TUNDRA("ICE_FLATS", "ICE_PLAINS"),
    STONE_SHORE("STONE_BEACH"),
    SUNFLOWER_PLAINS("MUTATED_PLAINS"),
    SWAMP("SWAMPLAND"),
    SWAMP_HILLS("MUTATED_SWAMPLAND", "SWAMPLAND_MOUNTAINS"),
    TAIGA("TAIGA"),
    TAIGA_HILLS("TAIGA_HILLS"),
    TAIGA_MOUNTAINS("MUTATED_TAIGA"),
    TALL_BIRCH_FOREST("MUTATED_BIRCH_FOREST", "BIRCH_FOREST_MOUNTAINS"),
    TALL_BIRCH_HILLS("MUTATED_BIRCH_FOREST_HILLS", "MESA_PLATEAU_FOREST_MOUNTAINS"),
    THE_END("SKY"),
    THE_VOID("VOID"),
    WARM_OCEAN("WARM_OCEAN"),
    WOODED_BADLANDS_PLATEAU("MESA_ROCK", "MESA_PLATEAU_FOREST"),
    WOODED_HILLS("FOREST_HILLS"),
    WOODED_MOUNTAINS("EXTREME_HILLS_WITH_TREES", "EXTREME_HILLS_PLUS"),
    BAMBOO_JUNGLE(new String[0]),
    BAMBOO_JUNGLE_HILLS(new String[0]);

    public static final EnumSet<XBiome> VALUES;
    private static final Cache<XBiome, com.google.common.base.Optional<Biome>> CACHE;
    private static final Pattern FORMAT_PATTERN;
    private String[] legacy;

    private XBiome(String ... legacy) {
        this.legacy = legacy;
    }

    @Nonnull
    private static String format(@Nonnull String name) {
        return FORMAT_PATTERN.matcher(name.trim().replace('-', '_').replace(' ', '_')).replaceAll("").toUpperCase(Locale.ENGLISH);
    }

    public static boolean contains(@Nonnull String biome) {
        Validate.notEmpty((String)biome, (String)"Cannot check for null or empty biome name");
        biome = XBiome.format(biome);
        for (XBiome biomes : VALUES) {
            if (!biomes.name().equals(biome) && !biomes.anyMatchLegacy(biome)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static Optional<XBiome> matchXBiome(@Nonnull String biome) {
        Validate.notEmpty((String)biome, (String)"Cannot match XBiome of a null or empty biome name");
        biome = XBiome.format(biome);
        for (XBiome biomes : VALUES) {
            if (!biomes.name().equals(biome) && !biomes.anyMatchLegacy(biome)) continue;
            return Optional.of(biomes);
        }
        return Optional.empty();
    }

    @Nonnull
    public static XBiome matchXBiome(@Nonnull Biome biome) {
        Objects.requireNonNull(biome, "Cannot match XBiome of a null biome");
        return XBiome.matchXBiome(biome.name()).orElseThrow(() -> new IllegalArgumentException("Unsupported Biome: " + biome.name()));
    }

    public boolean anyMatchLegacy(@Nonnull String biome) {
        Validate.notEmpty((String)biome, (String)"Cannot check for legacy name for null or empty biome name");
        return Arrays.asList(this.legacy).contains(XBiome.format(biome));
    }

    @Nullable
    public Biome parseBiome() {
        com.google.common.base.Optional cached = (com.google.common.base.Optional)CACHE.getIfPresent((Object)this);
        if (cached != null) {
            return (Biome)cached.orNull();
        }
        com.google.common.base.Optional biome = Enums.getIfPresent(Biome.class, (String)this.name());
        if (!biome.isPresent()) {
            String legacy;
            String[] stringArray = this.legacy;
            int n = stringArray.length;
            for (int i = 0; i < n && !(biome = Enums.getIfPresent(Biome.class, (String)(legacy = stringArray[i]))).isPresent(); ++i) {
            }
        }
        CACHE.put((Object)this, (Object)biome);
        return (Biome)biome.orNull();
    }

    @Nonnull
    public CompletableFuture<Void> setBiome(@Nonnull Chunk chunk) {
        Objects.requireNonNull(chunk, "Cannot set biome of null chunk");
        if (!chunk.isLoaded() && !chunk.load(true)) {
            throw new IllegalArgumentException("Could not load chunk at " + chunk.getX() + ", " + chunk.getZ());
        }
        Biome biome = this.parseBiome();
        if (biome == null) {
            throw new IllegalArgumentException("Unsupported Biome: " + this.name());
        }
        return CompletableFuture.runAsync(() -> {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block block = chunk.getBlock(x, 0, z);
                    if (block.getBiome() == biome) continue;
                    block.setBiome(biome);
                }
            }
        });
    }

    @Nonnull
    public CompletableFuture<Void> setBiome(@Nonnull Location start, @Nonnull Location end) {
        Objects.requireNonNull(start, "Start location cannot be null");
        Objects.requireNonNull(end, "End location cannot be null");
        if (!start.getWorld().getName().equals(end.getWorld().getName())) {
            throw new IllegalArgumentException("Location worlds mismatch");
        }
        Biome biome = this.parseBiome();
        if (biome == null) {
            throw new IllegalArgumentException("Unsupported Biome: " + this.name());
        }
        return CompletableFuture.runAsync(() -> {
            for (int x = start.getBlockX(); x < end.getBlockX(); ++x) {
                for (int z = start.getBlockZ(); z < end.getBlockZ(); ++z) {
                    Block block = new Location(start.getWorld(), (double)x, 0.0, (double)z).getBlock();
                    if (block.getBiome() == biome) continue;
                    block.setBiome(biome);
                }
            }
        });
    }

    static {
        VALUES = EnumSet.allOf(XBiome.class);
        CACHE = CacheBuilder.newBuilder().softValues().build();
        FORMAT_PATTERN = Pattern.compile("\\d+|\\W+");
    }
}

