/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.XMaterial;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullUtils {
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";
    private static final String SESSION = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final Pattern BASE64 = Pattern.compile("(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?");
    private static final Pattern USERNAME = Pattern.compile("[A-z0-9]+");

    @Nonnull
    public static ItemStack getSkull(@Nonnull UUID id) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (XMaterial.isNewVersion()) {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        } else {
            meta.setOwner(id.toString());
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull String player) {
        boolean isId = SkullUtils.isUUID(SkullUtils.getFullUUID(player));
        SkullMeta meta = (SkullMeta)head;
        if (isId || SkullUtils.isUsername(player)) {
            if (isId) {
                return SkullUtils.getSkullByValue(meta, SkullUtils.getSkinValue(player, true));
            }
            if (XMaterial.isNewVersion()) {
                meta.setOwningPlayer(Bukkit.getOfflinePlayer((String)player));
            } else {
                meta.setOwner(player);
            }
        }
        if (player.contains("textures.minecraft.net")) {
            return SkullUtils.getValueFromTextures(meta, player);
        }
        if (player.length() > 100 && SkullUtils.isBase64(player)) {
            return SkullUtils.getSkullByValue(meta, player);
        }
        return SkullUtils.getTexturesFromUrlValue(meta, player);
    }

    @Nonnull
    public static SkullMeta getSkullByValue(@Nonnull SkullMeta head, @Nonnull String value) {
        Validate.notEmpty((String)value, (String)"Skull value cannot be null or empty");
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
        try {
            Field profileField = head.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(head, profile);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace();
        }
        return head;
    }

    @Nonnull
    public static SkullMeta getValueFromTextures(@Nonnull SkullMeta head, @Nonnull String url) {
        return SkullUtils.getSkullByValue(head, SkullUtils.encodeBase64(VALUE_PROPERTY + url + "\"}}}"));
    }

    @Nonnull
    public static SkullMeta getTexturesFromUrlValue(@Nonnull SkullMeta head, @Nonnull String urlValue) {
        return SkullUtils.getValueFromTextures(head, TEXTURES + urlValue);
    }

    @Nonnull
    private static String encodeBase64(@Nonnull String str) {
        return Base64.getEncoder().encodeToString(str.getBytes());
    }

    private static boolean isBase64(String base64) {
        return BASE64.matcher(base64).matches();
    }

    @Nonnull
    public static String getSkinValue(@Nonnull ItemStack skull) {
        Objects.requireNonNull(skull, "Skull ItemStack cannot be null");
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        GameProfile profile = null;
        try {
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profile = (GameProfile)profileField.get(meta);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace();
        }
        if (profile != null && !profile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : profile.getProperties().get((Object)"textures")) {
                if (property.getValue().isEmpty()) continue;
                return property.getValue();
            }
        }
        return null;
    }

    @Nullable
    private static String getFullUUID(@Nullable String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return id;
        }
        if (id.length() == 36) {
            return id;
        }
        if (id.length() != 32) {
            return id;
        }
        return id.substring(0, 8) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32);
    }

    private static boolean isUUID(@Nullable String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return false;
        }
        return id.length() == 36 && StringUtils.countMatches((String)id, (String)"-") == 4;
    }

    private static boolean isUsername(@Nullable String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return false;
        }
        return name.length() >= 3 && name.length() <= 16 && USERNAME.matcher(name).matches();
    }

    @Nonnull
    public static String getSkinValue(@Nonnull String name, boolean isId) {
        Validate.notEmpty((String)name, (String)"Player name/UUID cannot be null or empty");
        try {
            String uuid;
            JsonParser parser = new JsonParser();
            if (!isId) {
                URL convertName = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
                InputStreamReader readId = new InputStreamReader(convertName.openStream());
                JsonObject jObject = parser.parse((Reader)readId).getAsJsonObject();
                if (SkullUtils.mojangError(jObject)) {
                    return null;
                }
                uuid = jObject.get("id").getAsString();
            } else {
                uuid = StringUtils.remove((String)name, (char)'-');
            }
            URL properties = new URL(SESSION + uuid);
            InputStreamReader readProperties = new InputStreamReader(properties.openStream());
            JsonObject jObjectP = parser.parse((Reader)readProperties).getAsJsonObject();
            if (SkullUtils.mojangError(jObjectP)) {
                return null;
            }
            JsonObject textureProperty = jObjectP.get("properties").getAsJsonArray().get(0).getAsJsonObject();
            return textureProperty.get("value").getAsString();
        }
        catch (IOException | IllegalStateException e) {
            System.err.println("Could not get skin data from session servers! " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static boolean mojangError(JsonObject jsonObject) {
        if (!jsonObject.has("error")) {
            return false;
        }
        String err = jsonObject.get("error").getAsString();
        String msg = jsonObject.get("errorMessage").getAsString();
        System.err.println("Mojang Error " + err + ": " + msg);
        return true;
    }
}

