/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.XParticle;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class ParticleDisplay {
    private static boolean ISFLAT = XParticle.getParticle("FOOTSTEP") == null;
    public Particle particle;
    public Location location;
    public int count;
    public double offsetx;
    public double offsety;
    public double offsetz;
    public double extra;
    public Vector rotation;
    public Object data;

    public ParticleDisplay(Particle particle, @Nullable Location location, int count, double offsetx, double offsety, double offsetz, double extra) {
        this.particle = particle;
        this.location = location;
        this.count = count;
        this.offsetx = offsetx;
        this.offsety = offsety;
        this.offsetz = offsetz;
        this.extra = extra;
    }

    public ParticleDisplay(Particle particle, Location location, int count, double offsetx, double offsety, double offsetz) {
        this(particle, location, count, offsetx, offsety, offsetz, 0.0);
    }

    public ParticleDisplay(Particle particle, Location location, int count) {
        this(particle, location, count, 0.0, 0.0, 0.0);
    }

    public ParticleDisplay(Particle particle, Location location) {
        this(particle, location, 0);
    }

    @Nonnull
    public static ParticleDisplay paintDust(@Nullable Location location, int r, int g, int b, float size) {
        ParticleDisplay dust = new ParticleDisplay(Particle.REDSTONE, location, 1, 0.0, 0.0, 0.0, 0.0);
        dust.data = new float[]{r, g, b, size};
        return dust;
    }

    @Nonnull
    public static ParticleDisplay simple(@Nullable Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(particle, "Cannot build ParticleDisplay with null particle");
        return new ParticleDisplay(particle, location, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Nonnull
    public static ParticleDisplay fromConfig(@Nullable Location location, @Nonnull ConfigurationSection config) {
        String[] rotations;
        String[] offsets;
        Objects.requireNonNull(config, "Cannot parse ParticleDisplay from a null config section");
        Particle particle = XParticle.getParticle(config.getString("particle"));
        if (particle == null) {
            particle = Particle.FLAME;
        }
        int count = config.getInt("count");
        double extra = config.getDouble("extra");
        double offsetx = 0.0;
        double offsety = 0.0;
        double offsetz = 0.0;
        String offset = config.getString("offset");
        if (offset != null && (offsets = StringUtils.split((String)offset, (char)',')).length > 0) {
            offsetx = NumberUtils.toDouble((String)offsets[0]);
            if (offsets.length > 1) {
                offsety = NumberUtils.toDouble((String)offsets[1]);
                if (offsets.length > 2) {
                    offsetz = NumberUtils.toDouble((String)offsets[2]);
                }
            }
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        String rotation = config.getString("offset");
        if (offset != null && (rotations = StringUtils.split((String)rotation, (char)',')).length > 0) {
            x = NumberUtils.toDouble((String)rotations[0]);
            if (rotations.length > 1) {
                y = NumberUtils.toDouble((String)rotations[1]);
                if (rotations.length > 2) {
                    z = NumberUtils.toDouble((String)rotations[2]);
                }
            }
        }
        Vector rotate = new Vector(x, y, z);
        ParticleDisplay display = new ParticleDisplay(particle, location, count, offsetx, offsety, offsetz, extra);
        display.rotation = rotate;
        return display;
    }

    @Nonnull
    public ParticleDisplay faceEntity(@Nonnull Entity entity) {
        Objects.requireNonNull(entity, "Cannot face null entity");
        Location loc = entity.getLocation();
        this.rotation = new Vector(Math.toRadians(loc.getPitch() + 90.0f), Math.toRadians(-loc.getYaw()), 0.0);
        return this;
    }

    @Nullable
    public Location cloneLocation(double x, double y, double z) {
        if (this.location == null) {
            return null;
        }
        return this.location.clone().add(x, y, z);
    }

    @Nonnull
    public ParticleDisplay cloneWithLocation(double x, double y, double z) {
        ParticleDisplay display = this.clone();
        if (this.location == null) {
            return display;
        }
        display.location.add(x, y, z);
        return display;
    }

    public ParticleDisplay clone() {
        ParticleDisplay display = new ParticleDisplay(this.particle, this.location == null ? null : this.location.clone(), this.count, this.offsetx, this.offsety, this.offsetz, this.extra);
        if (this.rotation != null) {
            display.rotation = this.rotation.clone();
        }
        display.data = this.data;
        return display;
    }

    public ParticleDisplay rotate(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot rotate ParticleDisplay with null vector");
        if (this.rotation == null) {
            this.rotation = vector;
        } else {
            this.rotation.add(vector);
        }
        return this;
    }

    public ParticleDisplay rotate(double x, double y, double z) {
        this.rotate(new Vector(x, y, z));
        return this;
    }

    public void spawn(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot add xyz of null vector to ParticleDisplay");
        this.spawn(vector.getX(), vector.getY(), vector.getZ());
    }

    public ParticleDisplay offset(double x, double y, double z) {
        this.offsetx = x;
        this.offsety = y;
        this.offsetz = z;
        return this;
    }

    public ParticleDisplay directional() {
        this.count = 0;
        return this;
    }

    public boolean isDirectional() {
        return this.count == 0;
    }

    public void spawn() {
        this.spawn(this.location);
    }

    public Location spawn(double x, double y, double z) {
        Location loc;
        if (this.rotation != null) {
            Vector rotate = new Vector(x, y, z);
            if (this.rotation.getX() != 0.0) {
                XParticle.rotateAroundX(rotate, this.rotation.getX());
            }
            if (this.rotation.getY() != 0.0) {
                XParticle.rotateAroundY(rotate, this.rotation.getY());
            }
            if (this.rotation.getZ() != 0.0) {
                XParticle.rotateAroundZ(rotate, this.rotation.getZ());
            }
            loc = this.location.clone().add(rotate);
        } else {
            loc = this.location.clone().add(x, y, z);
        }
        this.spawn(loc);
        return loc;
    }

    public void spawn(Location loc) {
        if (this.data != null) {
            if (this.data instanceof float[]) {
                float[] datas = (float[])this.data;
                if (ISFLAT) {
                    Particle.DustOptions dust = new Particle.DustOptions(Color.fromRGB((int)((int)datas[0]), (int)((int)datas[1]), (int)((int)datas[2])), datas[3]);
                    loc.getWorld().spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, (Object)dust);
                } else {
                    loc.getWorld().spawnParticle(this.particle, loc, this.count, (double)((int)datas[0]), (double)((int)datas[1]), (double)((int)datas[2]), (double)datas[3]);
                }
            }
        } else {
            loc.getWorld().spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra);
        }
    }
}

