/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Note;
import org.bukkit.entity.Player;

public class NoteBlockMusic {
    private static final ImmutableMap<String, Instrument> INSTRUMENTS;
    private static final Pattern SPLITTER;

    public static CompletableFuture<Void> testMusic(@Nonnull Player player) {
        return NoteBlockMusic.playMusic(player, player.getLocation(), "PIANO,D,2,100 PIANO,B#1 200 PIANO,F 250 PIANO,E 250 PIANO,B 200 PIANO,A 100 PIANO,B 100 PIANO,E");
    }

    public static CompletableFuture<Void> fromFile(@Nonnull Player player, @Nonnull Location location, @Nonnull Path path) {
        return CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    NoteBlockMusic.parseSegment(player, location, line, 1, 0);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    public static CompletableFuture<Void> playMusic(@Nonnull Player player, @Nonnull Location location, @Nullable String script) {
        return CompletableFuture.runAsync(() -> {
            if (Strings.isNullOrEmpty((String)script)) {
                return;
            }
            NoteBlockMusic.parseSegment(player, location, script, 1, 0);
        });
    }

    private static void parseSegment(@Nonnull Player player, @Nonnull Location location, @Nonnull String script, int segmentRepeat, int segmentDelay) {
        ArrayList<String> repeater = new ArrayList<String>();
        String[] splitScript = SPLITTER.split(script);
        while (segmentRepeat > 0) {
            for (String action : splitScript) {
                String note;
                Note.Tone tone;
                int betweenDelay = NumberUtils.toInt((String)action);
                if (betweenDelay > 1) {
                    if (!repeater.isEmpty()) {
                        String old = (String)repeater.remove(repeater.size() - 1);
                        repeater.add(old + " " + betweenDelay);
                    }
                    try {
                        Thread.sleep(betweenDelay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String[] split = StringUtils.split((String)StringUtils.deleteWhitespace((String)action.toUpperCase()), (char)',');
                String instrumentStr = split[0].toUpperCase();
                if (instrumentStr.charAt(0) == '(') {
                    repeater.add(action.substring(1));
                    instrumentStr = instrumentStr.substring(1);
                } else {
                    int index = action.indexOf(41);
                    if (!repeater.isEmpty()) {
                        String old = (String)repeater.remove(repeater.size() - 1);
                        String add = index == -1 ? action : action.substring(0, index);
                        repeater.add(old + " " + add);
                    }
                    if (index != -1) {
                        String[] segmentProperties = StringUtils.split((String)action.substring(index + 1), (char)',');
                        int newSegmentRepeat = 1;
                        int newSegmentDelay = 0;
                        if (segmentProperties.length > 0) {
                            try {
                                newSegmentRepeat = Integer.parseInt(segmentProperties[0]);
                                if (segmentProperties.length > 1) {
                                    newSegmentDelay = Integer.parseInt(segmentProperties[1]);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        NoteBlockMusic.parseSegment(player, location, (String)repeater.remove(repeater.size() - 1), newSegmentRepeat, newSegmentDelay);
                        continue;
                    }
                }
                Instrument instrument = (Instrument)INSTRUMENTS.get((Object)instrumentStr);
                if (instrument == null || (tone = (Note.Tone)Enums.getIfPresent(Note.Tone.class, (String)((note = split[1].toUpperCase()).charAt(0) + "")).orNull()) == null) continue;
                int len = note.length();
                char toneType = ' ';
                int octave = 0;
                if (len > 1) {
                    toneType = note.charAt(1);
                    if (Character.isDigit(toneType)) {
                        octave = NumberUtils.toInt((String)(toneType + ""));
                    } else if (len > 2) {
                        octave = NumberUtils.toInt((String)(note.charAt(2) + ""));
                    }
                    if (octave < 0 || octave > 2) {
                        octave = 0;
                    }
                }
                Note noteObj = toneType == '#' ? Note.sharp((int)octave, (Note.Tone)tone) : (toneType == '_' ? Note.flat((int)octave, (Note.Tone)tone) : Note.natural((int)octave, (Note.Tone)tone));
                int repeat = 1;
                int delay = 0;
                if (split.length > 2) {
                    try {
                        repeat = Integer.parseInt(split[2]);
                        if (split.length > 3) {
                            delay = Integer.parseInt(split[3]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                while (repeat > 0) {
                    player.playNote(location, instrument, noteObj);
                    if (repeat != 0 && delay > 1) {
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    --repeat;
                }
            }
            if (segmentDelay > 1) {
                try {
                    Thread.sleep(segmentDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            --segmentRepeat;
        }
    }

    static {
        SPLITTER = Pattern.compile("\\s+");
        HashMap<String, Instrument> instruments = new HashMap<String, Instrument>();
        block0: for (Instrument instrument : Instrument.values()) {
            String name = instrument.name();
            instruments.put(name, instrument);
            StringBuilder alias = new StringBuilder(name.charAt(0) + "");
            int index = name.indexOf(95);
            if (index != -1) {
                alias.append(name.charAt(index + 1));
            }
            if (!instruments.containsKey(alias.toString())) {
                instruments.put(alias.toString(), instrument);
                continue;
            }
            boolean start = false;
            for (char letter : name.toCharArray()) {
                if (!start) {
                    start = true;
                    continue;
                }
                if (letter == '_') {
                    start = false;
                    continue;
                }
                alias.append(letter);
                if (instruments.containsKey(alias.toString())) continue;
                instruments.put(alias.toString(), instrument);
                continue block0;
            }
        }
        INSTRUMENTS = ImmutableMap.copyOf(instruments);
    }
}

