/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.XMaterial;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Material;

public class Examples {
    private static void print(String str) {
        Bukkit.getLogger().info(str);
    }

    public static void testMaterials() {
        XMaterial[] subjects;
        for (XMaterial subject : subjects = new XMaterial[]{XMaterial.MELON, XMaterial.MELON_SLICE, XMaterial.CARROT, XMaterial.CARROTS, XMaterial.MAP, XMaterial.FILLED_MAP, XMaterial.BLACK_GLAZED_TERRACOTTA, XMaterial.COD_BUCKET, XMaterial.WHITE_DYE}) {
            Material parsed = subject.parseMaterial();
            Material suggestion = subject.parseMaterial(true);
            Examples.print("Matched(" + subject.name() + ") -> " + XMaterial.matchXMaterial(subject.name()) + ", parsed: " + parsed + ", suggestion: " + suggestion);
        }
    }

    public static void convertYAMLMaterial(File file) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.trim().startsWith("type:")) {
                    sb.append(line);
                } else {
                    int index = line.indexOf(58);
                    String material = line.substring(index + 1);
                    XMaterial mat = XMaterial.matchXMaterial(material).orElse(null);
                    if (mat == null || mat.name().contains(mat.parseMaterial().name()) || mat.parseMaterial().name().contains(mat.name())) {
                        sb.append(line).append(System.lineSeparator());
                        continue;
                    }
                    sb.append(line, 0, index).append(": ").append(mat.parseMaterial().name());
                    if (!XMaterial.isNewVersion() && mat.getData() != 0) {
                        sb.append(System.lineSeparator());
                        sb.append(line, 0, index - 4).append("damage: ").append(mat.getData());
                    }
                }
                sb.append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(sb.toString());
            writer.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static <S extends Enum<S>, E extends Enum<E>> void writeDifference(@Nonnull Path path, @Nonnull Class<S> system, @Nonnull Class<E> custom) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            boolean exists;
            for (Enum systemConst : (Enum[])system.getEnumConstants()) {
                exists = false;
                for (Enum customConst : (Enum[])custom.getEnumConstants()) {
                    if (!systemConst.name().equals(customConst.name())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                writer.write(systemConst.name());
                writer.newLine();
            }
            writer.write("--------------------------------");
            for (Enum customConst : (Enum[])custom.getEnumConstants()) {
                exists = false;
                for (Enum systemConst : (Enum[])system.getEnumConstants()) {
                    if (!systemConst.name().equals(customConst.name())) continue;
                    exists = true;
                    break;
                }
                if (exists || exists) continue;
                writer.write(customConst.name());
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

