/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.yaml.configuration.file;

import io.github.portlek.configs.yaml.configuration.ConfigurationSection;
import io.github.portlek.configs.yaml.configuration.serialization.ConfigurationSerializable;
import io.github.portlek.configs.yaml.configuration.serialization.ConfigurationSerialization;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.representer.SafeRepresenter;

public class YamlRepresenter
extends Representer {
    public YamlRepresenter() {
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
    }

    private class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super((SafeRepresenter)YamlRepresenter.this);
        }

        @NotNull
        public Node representData(@NotNull Object data) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)data;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values.putAll(serializable.serialize());
            return super.representData(values);
        }
    }

    private class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super((SafeRepresenter)YamlRepresenter.this);
        }

        @NotNull
        public Node representData(@NotNull Object data) {
            return super.representData(((ConfigurationSection)data).getValues(false));
        }
    }
}

