/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class BukkitVersion {
    @NotNull
    private static final Pattern PATTERN = Pattern.compile("v?(?<major>[0-9]+)[._](?<minor>[0-9]+)(?:[._](?<micro>[0-9]+))?(?<sub>.*)");
    @NotNull
    private final String version;

    public BukkitVersion() {
        this(Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1));
    }

    public BukkitVersion(@NotNull String version) {
        this.version = version;
    }

    @NotNull
    public String raw() {
        return this.version;
    }

    public int major() {
        Matcher matcher = PATTERN.matcher(this.version);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group("major"));
        }
        return 0;
    }

    public int minor() {
        Matcher matcher = PATTERN.matcher(this.version);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group("minor"));
        }
        return 0;
    }

    public int micro() {
        Matcher matcher = PATTERN.matcher(this.version);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group("micro"));
        }
        return 0;
    }
}

