/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import io.github.portlek.bukkititembuilder.util.ColorUtil;
import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.util.BukkitVersion;
import io.github.portlek.configs.util.Provided;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class BukkitItemStackProvider
implements Provided<ItemStack> {
    private static final BukkitVersion BUKKIT_VERSION = new BukkitVersion();

    @NotNull
    private static String putDot(@NotNull String text) {
        String fnltext = text.isEmpty() || text.charAt(text.length() - 1) == '.' ? text : text + '.';
        return fnltext;
    }

    @Override
    public void set(@NotNull ItemStack itemStack, @NotNull CfgSection section, @NotNull String path) {
        String fnlpath = BukkitItemStackProvider.putDot(path);
        section.set(fnlpath + "material", itemStack.getType().name());
        section.set(fnlpath + "amount", itemStack.getAmount());
        if (BUKKIT_VERSION.minor() < 13) {
            Optional.ofNullable(itemStack.getData()).ifPresent(materialData -> section.set(fnlpath + "data", materialData.getData()));
        }
        if (itemStack.getDurability() != 0) {
            section.set(fnlpath + "damage", itemStack.getDurability());
        }
        Optional.ofNullable(itemStack.getItemMeta()).ifPresent(itemMeta -> {
            if (itemMeta.hasDisplayName()) {
                section.set(fnlpath + "display-name", itemMeta.getDisplayName().replace("\u00a7", "&"));
            }
            Optional.ofNullable(itemMeta.getLore()).ifPresent(lore -> section.set(fnlpath + "lore", lore.stream().map(s -> s.replace("\u00a7", "&")).collect(Collectors.toList())));
            section.set(fnlpath + "flags", itemMeta.getItemFlags().stream().map(Enum::name).collect(Collectors.toList()));
        });
        itemStack.getEnchantments().forEach((enchantment, integer) -> section.set(fnlpath + "enchants." + enchantment.getName(), integer));
    }

    @Override
    @NotNull
    public Optional<ItemStack> get(@NotNull CfgSection section, @NotNull String path) {
        Material material;
        String fnlpath = BukkitItemStackProvider.putDot(path);
        Optional<String> optional = section.getString(fnlpath + "material");
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        String mtrlstrng = optional.get();
        if (BUKKIT_VERSION.minor() > 7) {
            Optional<XMaterial> xmaterialoptional = XMaterial.matchXMaterial(mtrlstrng);
            if (!xmaterialoptional.isPresent()) {
                return Optional.empty();
            }
            Optional<Material> mtrloptnl = Optional.ofNullable(xmaterialoptional.get().parseMaterial());
            if (!mtrloptnl.isPresent()) {
                return Optional.empty();
            }
            material = mtrloptnl.get();
        } else {
            material = Material.getMaterial((String)mtrlstrng);
        }
        int amount = section.getInt(fnlpath + "amount");
        int fnlamnt = amount == 0 ? 1 : amount;
        ItemStack itemStack = BUKKIT_VERSION.minor() < 13 ? new ItemStack(material, fnlamnt, (short)section.getInt(fnlpath + "damage"), Byte.valueOf((byte)section.getInt(fnlpath + "data"))) : new ItemStack(material, fnlamnt, (short)section.getInt(fnlpath + "damage"));
        Optional.ofNullable(itemStack.getItemMeta()).ifPresent(itemMeta -> {
            section.getString(fnlpath + "display-name").ifPresent(s -> itemMeta.setDisplayName(ColorUtil.colored(s)));
            itemMeta.setLore(ColorUtil.colored(section.getStringList(fnlpath + "lore")));
            section.getSection(fnlpath + "enchants").map(enchsection -> enchsection.getKeys(false)).ifPresent(set -> set.forEach(s -> XEnchantment.matchXEnchantment(s).flatMap(xEnchantment -> Optional.ofNullable(xEnchantment.parseEnchantment())).ifPresent(enchantment -> itemMeta.addEnchant(enchantment, section.getInt(fnlpath + "enchants." + s), true))));
            section.getStringList(fnlpath + "flags").stream().map(ItemFlag::valueOf).forEach(xva$0 -> itemMeta.addItemFlags(new ItemFlag[]{xva$0}));
            itemStack.setItemMeta(itemMeta);
        });
        return Optional.of(itemStack);
    }
}

