/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.processors;

import io.github.portlek.configs.LnkdFlManaged;
import io.github.portlek.configs.annotations.Config;
import io.github.portlek.configs.annotations.LinkedConfig;
import io.github.portlek.configs.processors.ConfigProceed;
import io.github.portlek.configs.processors.Proceed;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class LinkedConfigProceed
implements Proceed<LnkdFlManaged> {
    @NotNull
    private final LinkedConfig config;

    public LinkedConfigProceed(@NotNull LinkedConfig cnfg) {
        this.config = cnfg;
    }

    @Override
    public void load(@NotNull LnkdFlManaged linked) {
        Arrays.stream(this.config.configs()).filter(config -> {
            String chosen;
            String suffix = config.type().suffix;
            String name = config.name();
            if (!name.endsWith(suffix)) {
                name = name + suffix;
            }
            if (!(chosen = linked.getChosen()).endsWith(suffix)) {
                chosen = chosen + suffix;
            }
            return name.equals(chosen);
        }).findFirst().ifPresent(config -> new ConfigProceed((Config)config).load(linked));
    }
}

