/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.processors;

import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.annotations.Config;
import io.github.portlek.configs.processors.FieldsProceed;
import io.github.portlek.configs.processors.Proceed;
import io.github.portlek.configs.util.Basedir;
import io.github.portlek.configs.util.FileType;
import io.github.portlek.configs.util.Version;
import io.github.portlek.configs.yaml.configuration.file.FileConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigProceed
implements Proceed<FlManaged> {
    @NotNull
    private final Config config;

    public ConfigProceed(@NotNull Config cnfg) {
        this.config = cnfg;
    }

    @NotNull
    private static String addSeparatorIfHasNot(@NotNull String raw) {
        String fnl = raw.isEmpty() ? "" : (raw.charAt(raw.length() - 1) == File.separatorChar ? raw : raw + File.separatorChar);
        return fnl;
    }

    @Nullable
    private static InputStream getResource(@NotNull String path) {
        return Optional.ofNullable(ConfigProceed.class.getClassLoader().getResource(path)).map(url -> {
            try {
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                return connection.getInputStream();
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return null;
            }
        }).orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(@NotNull FlManaged managed) {
        FileType type = this.config.type();
        String name = this.config.name().endsWith(type.suffix) ? this.config.name() : this.config.name() + type.suffix;
        Version version = Version.of(this.config.version());
        String versionpath = this.config.versionPath();
        Optional<File> optional = new Basedir(managed.getClass()).value();
        if (!optional.isPresent()) {
            return;
        }
        File basedir = optional.get();
        String filelocation = ConfigProceed.addSeparatorIfHasNot(this.config.location().replace("%basedir%", basedir.getParentFile().getAbsolutePath()).replace("/", File.separator));
        String jarlocation = ConfigProceed.addSeparatorIfHasNot(this.config.location().replace("%basedir%", basedir.getAbsolutePath()).replace("/", File.separator));
        File file = this.config.copyDefault() ? this.saveResource(jarlocation, ConfigProceed.addSeparatorIfHasNot(this.config.resourcePath()) + name) : new File(filelocation, name);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfiguration configuration = type.load(file);
        managed.setup(file, configuration);
        Optional<String> versionoptional = managed.getString(versionpath);
        if (versionoptional.isPresent()) {
            Version fileversion = Version.of(versionoptional.get());
            if (version.is(fileversion)) {
                // empty if block
            }
        } else {
            version.write(versionpath, managed);
        }
        new FieldsProceed(managed).load(managed);
        managed.save();
    }

    @NotNull
    public File saveResource(@NotNull String datafolder, @NotNull String path) {
        File outfile;
        int lastindex;
        if (path.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be empty");
        }
        String replace = path.replace('\\', '/');
        File outdir = new File(datafolder, replace.substring(0, Math.max(lastindex = replace.lastIndexOf(47), 0)));
        if (!outdir.exists()) {
            outdir.getParentFile().mkdirs();
            outdir.mkdirs();
        }
        if (!(outfile = new File(datafolder, replace)).exists()) {
            try (FileOutputStream out = new FileOutputStream(outfile);
                 InputStream input = ConfigProceed.getResource(replace);){
                int len;
                if (input == null) {
                    throw new IllegalArgumentException("The embedded resource '" + replace + "' cannot be found!");
                }
                byte[] buf = new byte[1024];
                while ((len = input.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        return outfile;
    }
}

