/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.FileManaged;
import io.github.portlek.configs.LnkdFlManaged;
import io.github.portlek.configs.util.MapEntry;
import io.github.portlek.configs.yaml.configuration.file.FileConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class LinkedFileManaged
extends FileManaged
implements LnkdFlManaged {
    @NotNull
    private final Map<String, Map.Entry<File, FileConfiguration>> linkedFiles = new HashMap<String, Map.Entry<File, FileConfiguration>>();
    @NotNull
    private final String chosen;

    @SafeVarargs
    protected LinkedFileManaged(@NotNull String chosen, Map.Entry<String, Object> ... objects) {
        super(objects);
        this.chosen = chosen;
    }

    @Override
    @NotNull
    public final <T> T match(@NotNull Function<String, Optional<T>> function) {
        return function.apply(this.chosen).orElseThrow(() -> new IllegalStateException("Cannot found match with the file id > " + this.chosen));
    }

    @Override
    @NotNull
    public final String getChosen() {
        return this.chosen;
    }

    @Override
    public final void setup(@NotNull File file, @NotNull FileConfiguration fileConfiguration) {
        super.setup(file, fileConfiguration);
        this.linkedFiles.put(this.chosen, MapEntry.from(file, fileConfiguration));
    }
}

