/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkititembuilder;

import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Multimap;
import io.github.portlek.bukkititembuilder.BannerItemBuilder;
import io.github.portlek.bukkititembuilder.BookItemBuilder;
import io.github.portlek.bukkititembuilder.Builder;
import io.github.portlek.bukkititembuilder.CrossbowItemBuilder;
import io.github.portlek.bukkititembuilder.FireworkItemBuilder;
import io.github.portlek.bukkititembuilder.MapItemBuilder;
import io.github.portlek.bukkititembuilder.SkullItemBuilder;
import io.github.portlek.bukkititembuilder.util.ColorUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackBuilder
extends Builder<ItemStackBuilder, ItemMeta> {
    private ItemStackBuilder(@NotNull ItemStack item) {
        super(item, Objects.requireNonNull(item.getItemMeta(), "ItemMeta of " + item + " couldn't chain!"));
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull XMaterial material) {
        return ItemStackBuilder.from(Optional.ofNullable(material.parseMaterial()).orElseThrow(() -> new IllegalStateException("Material from the " + material.name() + " cannot be null!")));
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull Material material) {
        return ItemStackBuilder.from(new ItemStack(material));
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull ItemStack from) {
        return new ItemStackBuilder(from);
    }

    @Override
    public ItemStackBuilder chain() {
        return this;
    }

    @NotNull
    public ItemStackBuilder localizedName(@Nullable String name) {
        return (ItemStackBuilder)this.update(meta -> meta.setLocalizedName(name));
    }

    @NotNull
    public ItemStackBuilder customModelData(@Nullable Integer data) {
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.setCustomModelData(data));
    }

    @NotNull
    public ItemStackBuilder unbreakable(boolean unbreakable) {
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.setUnbreakable(unbreakable));
    }

    @NotNull
    public ItemStackBuilder addAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.addAttributeModifier(attribute, modifier));
    }

    @NotNull
    public ItemStackBuilder addAttributeModifier(@NotNull Multimap<Attribute, AttributeModifier> map) {
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.setAttributeModifiers(map));
    }

    @NotNull
    public ItemStackBuilder removeAttributeModifier(@NotNull Attribute attribute) {
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.removeAttributeModifier(attribute));
    }

    @NotNull
    public ItemStackBuilder removeAttributeModifier(@NotNull EquipmentSlot slot) {
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.removeAttributeModifier(slot));
    }

    @NotNull
    public ItemStackBuilder removeAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.removeAttributeModifier(attribute, modifier));
    }

    @NotNull
    public ItemStackBuilder version(int version) {
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.setVersion(version));
    }

    @NotNull
    public ItemStackBuilder name(@NotNull String name) {
        return this.name(name, true);
    }

    @NotNull
    public ItemStackBuilder name(@NotNull String name, boolean colored) {
        String fnlname = colored ? ColorUtil.colored(name) : name;
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.setDisplayName(fnlname));
    }

    @NotNull
    public CrossbowItemBuilder crossbow() {
        return new CrossbowItemBuilder(this.itemstack, this.validateMeta(CrossbowMeta.class));
    }

    @NotNull
    private <T extends ItemMeta> T validateMeta(@NotNull Class<T> meta) {
        if (!meta.isAssignableFrom(this.meta.getClass())) {
            throw new IllegalStateException(this.itemstack + " is not a banner!");
        }
        return (T)this.meta;
    }

    @NotNull
    public MapItemBuilder map() {
        return new MapItemBuilder(this.itemstack, this.validateMeta(MapMeta.class));
    }

    @NotNull
    public SkullItemBuilder skull() {
        return new SkullItemBuilder(this.itemstack, this.validateMeta(SkullMeta.class));
    }

    @NotNull
    public BannerItemBuilder banner() {
        return new BannerItemBuilder(this.itemstack, this.validateMeta(BannerMeta.class));
    }

    @NotNull
    public BookItemBuilder book() {
        return new BookItemBuilder(this.itemstack, this.validateMeta(BookMeta.class));
    }

    @NotNull
    public ItemStackBuilder amount(int size) {
        this.build().setAmount(size);
        return this;
    }

    @NotNull
    public ItemStackBuilder flag(ItemFlag ... flags) {
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.addItemFlags(flags));
    }

    @NotNull
    public FireworkItemBuilder firework() {
        return new FireworkItemBuilder(this.itemstack, this.validateMeta(FireworkMeta.class));
    }

    @NotNull
    public ItemStackBuilder data(byte data) {
        MaterialData materialData = this.build().getData();
        materialData.setData(data);
        this.build().setData(materialData);
        return this;
    }

    @NotNull
    public ItemStackBuilder damage(short damage) {
        this.build().setDurability(damage);
        return this;
    }

    @NotNull
    public ItemStackBuilder lore(String ... lore) {
        return this.lore(Arrays.asList(lore), true);
    }

    @NotNull
    public ItemStackBuilder lore(@NotNull List<String> lore, boolean colored) {
        List<String> fnllore = colored ? ColorUtil.colored(lore) : lore;
        return (ItemStackBuilder)this.update(itemMeta -> itemMeta.setLore(fnllore));
    }

    @NotNull
    public ItemStackBuilder enchantments(String ... enchantments) {
        for (String enchstring : enchantments) {
            int level;
            String enchantment;
            String[] split = enchstring.split(":");
            if (split.length == 1) {
                enchantment = split[0];
                level = 1;
            } else {
                enchantment = split[0];
                level = ItemStackBuilder.getInt(split[1]);
            }
            XEnchantment.matchXEnchantment(enchantment).ifPresent(xEnchantment -> this.enchantments((XEnchantment)((Object)xEnchantment), level));
        }
        return this;
    }

    private static int getInt(@NotNull String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @NotNull
    public ItemStackBuilder enchantments(@NotNull XEnchantment enchantment, int level) {
        return Optional.ofNullable(enchantment.parseEnchantment()).map(value -> this.enchantments((Enchantment)value, level)).orElse(this);
    }

    @NotNull
    public ItemStackBuilder enchantments(@NotNull Enchantment enchantment, int level) {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        map.put(enchantment, level);
        return this.enchantments(map);
    }

    @NotNull
    public ItemStackBuilder enchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        this.build().addUnsafeEnchantments(enchantments);
        return this;
    }
}

