/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkititembuilder;

import io.github.portlek.bukkititembuilder.Builder;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;

public final class FireworkItemBuilder
extends Builder<FireworkItemBuilder, FireworkMeta> {
    public FireworkItemBuilder(@NotNull ItemStack item, @NotNull FireworkMeta meta) {
        super(item, meta);
    }

    @NotNull
    public FireworkItemBuilder power(int power) {
        return (FireworkItemBuilder)this.update(meta -> meta.setPower(power));
    }

    @NotNull
    public FireworkItemBuilder removeEffect(int effectid) {
        return (FireworkItemBuilder)this.update(meta -> meta.removeEffect(effectid));
    }

    @NotNull
    public FireworkItemBuilder clearEffects() {
        return (FireworkItemBuilder)this.update(FireworkMeta::clearEffects);
    }

    @NotNull
    public FireworkItemBuilder addEffect(@NotNull FireworkEffect effect) {
        return (FireworkItemBuilder)this.update(meta -> meta.addEffect(effect));
    }

    @NotNull
    public FireworkItemBuilder addEffects(FireworkEffect ... effects) {
        return (FireworkItemBuilder)this.update(meta -> meta.addEffects(effects));
    }

    @NotNull
    public FireworkItemBuilder addEffects(@NotNull Iterable<FireworkEffect> effects) {
        return (FireworkItemBuilder)this.update(meta -> meta.addEffects(effects));
    }

    @Override
    @NotNull
    public FireworkItemBuilder chain() {
        return this;
    }
}

