/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.moltenjson.utils.Gsons;
import net.moltenjson.utils.ReflectiveTypes;
import org.jetbrains.annotations.NotNull;

public class JsonUtils {
    private JsonUtils() {
        throw new AssertionError((Object)(JsonUtils.class.getName() + " cannot be initiated!"));
    }

    public static String setPretty(@NotNull String json) {
        return Gsons.PRETTY_PRINTING.toJson((JsonElement)JsonUtils.getObjectFromString(json));
    }

    public static JsonElement getElementFromString(@NotNull String json, @NotNull Gson gson) {
        return (JsonElement)gson.fromJson(json, ReflectiveTypes.ELEMENT_TYPE);
    }

    public static JsonElement getElementFromString(@NotNull String json) {
        return JsonUtils.getElementFromString(json, Gsons.DEFAULT);
    }

    public static JsonObject getObjectFromString(@NotNull String json, @NotNull Gson gson) {
        return JsonUtils.getElementFromString(json, gson).getAsJsonObject();
    }

    public static JsonObject getObjectFromString(@NotNull String json) {
        return JsonUtils.getObjectFromString(json, Gsons.DEFAULT);
    }

    public static Map<String, Object> toMap(@NotNull String json) {
        return (Map)Gsons.DEFAULT.fromJson(json, ReflectiveTypes.MAP_TYPE);
    }

    public static Map<String, Object> toMap(@NotNull JsonElement json) {
        return (Map)Gsons.DEFAULT.fromJson(json, ReflectiveTypes.MAP_TYPE);
    }

    public static List<Object> toList(@NotNull String json) {
        return (List)Gsons.DEFAULT.fromJson(json, ReflectiveTypes.LIST_TYPE);
    }

    public static List<Object> toList(@NotNull JsonElement json) {
        return (List)Gsons.DEFAULT.fromJson(json, ReflectiveTypes.LIST_TYPE);
    }
}

