/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.moltenjson.utils.Gsons;
import net.moltenjson.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBuilder {
    private final Map<String, Object> jsonMap;

    public JsonBuilder(boolean order) {
        this.jsonMap = order ? new LinkedHashMap() : new HashMap();
    }

    public JsonBuilder() {
        this(true);
    }

    public JsonBuilder(@NotNull JsonObject object) {
        this.jsonMap = JsonUtils.toMap((JsonElement)object);
    }

    public JsonBuilder(@NotNull Map<String, Object> jsonMap) {
        this.jsonMap = jsonMap;
    }

    public JsonBuilder map(@NotNull String key, @Nullable Object value) {
        this.jsonMap.put(key, value);
        return this;
    }

    public JsonBuilder mapIf(boolean expression, @NotNull String key, @Nullable Object value) {
        if (expression) {
            return this.map(key, value);
        }
        return this;
    }

    public <T> JsonBuilder mapIf(@Nullable Predicate<T> predicate, @NotNull String key, @Nullable T value) {
        return this.mapIf(predicate == null || predicate.test(value), key, value);
    }

    public JsonBuilder mapIfNotNull(@NotNull String key, @Nullable Object value) {
        return this.mapIf(Objects::nonNull, key, value);
    }

    public JsonBuilder mapIfAbsent(@NotNull String key, @Nullable Object value) {
        return this.mapIf(o -> this.jsonMap.containsKey(key), key, value);
    }

    public JsonBuilder removeKey(@NotNull String key) {
        this.jsonMap.remove(key);
        return this;
    }

    public Map<String, Object> getJsonMap() {
        return this.jsonMap;
    }

    public String build() {
        return this.build(Gsons.DEFAULT);
    }

    public String buildPretty() {
        return this.build(Gsons.PRETTY_PRINTING);
    }

    public String build(@NotNull Gson profile) {
        return profile.toJson(this.jsonMap);
    }

    public JsonObject buildJsonObject() {
        return this.buildJsonElement().getAsJsonObject();
    }

    public JsonElement buildJsonElement() {
        return JsonUtils.getElementFromString(this.build());
    }
}

