/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import net.moltenjson.json.JsonFile;
import net.moltenjson.json.JsonReader;
import net.moltenjson.json.Lockable;
import net.moltenjson.json.Refreshable;
import net.moltenjson.utils.Gsons;
import net.moltenjson.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;

public class JsonWriter
implements Closeable,
Lockable<JsonWriter>,
Refreshable<JsonWriter> {
    private static final JsonObject EMPTY = new JsonObject();
    private BufferedWriter bufferedWriter;
    private JsonFile file;
    private JsonElement contentElement;
    private JsonObject content;
    private JsonReader reader;
    private final boolean locked;

    public JsonWriter(@NotNull JsonFile file, boolean locked) throws IOException {
        this.file = file;
        this.locked = locked;
        this.reader = new JsonReader(file);
        try {
            this.contentElement = this.reader.getJsonElement(Throwable::printStackTrace);
            this.content = this.contentElement.getAsJsonObject();
        }
        catch (IllegalStateException e) {
            this.content = EMPTY;
        }
        this.reader.close();
    }

    public JsonWriter(@NotNull JsonFile file) throws IOException {
        this(file, false);
    }

    public JsonWriter(@NotNull BufferedWriter writer, boolean locked) {
        this.bufferedWriter = writer;
        this.locked = locked;
    }

    public JsonWriter(@NotNull BufferedWriter writer) {
        this(writer, false);
    }

    public void writeAndOverride(@NotNull Object jsonResult, boolean prettyPrinting) throws IOException {
        this.writeAndOverride(jsonResult, prettyPrinting ? Gsons.PRETTY_PRINTING : Gsons.DEFAULT);
    }

    public void writeAndOverride(@NotNull Object jsonResult, @NotNull Gson gson) throws IOException {
        this.write(gson.toJson(jsonResult));
    }

    public JsonObject add(@NotNull String key, @NotNull Object value, boolean prettyPrinting, boolean override) throws IOException {
        if (this.memberExists(key) && !override) {
            return this.content;
        }
        this.content.add(key, Gsons.DEFAULT.toJsonTree(value));
        this.write(prettyPrinting ? JsonUtils.setPretty(this.content.toString()) : this.content.toString());
        return this.content;
    }

    public JsonObject add(@NotNull String key, @NotNull Object value, boolean prettyPrinting) throws IOException {
        return this.add(key, value, prettyPrinting, false);
    }

    public JsonObject add(@NotNull String key, @NotNull Object value) throws IOException {
        return this.add(key, value, false);
    }

    public JsonObject removeKey(@NotNull String key, boolean prettyPrinting) throws IOException {
        this.content.remove(key);
        this.write(prettyPrinting ? JsonUtils.setPretty(this.content.toString()) : this.content.toString());
        return this.content;
    }

    public JsonObject removeKey(@NotNull String key) throws IOException {
        return this.removeKey(key, true);
    }

    public boolean memberExists(@NotNull String key) {
        return this.content.has(key);
    }

    public JsonObject getCachedContentAsObject() {
        return this.content;
    }

    public JsonElement getCachedContentAsElement() {
        return this.contentElement;
    }

    private void write(@NotNull String text) throws IOException {
        if (this.bufferedWriter != null) {
            this.bufferedWriter.write(text);
        } else {
            Files.write(Paths.get(this.file.getPath(), new String[0]), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    @Override
    public JsonWriter setFile(@NotNull JsonFile file) {
        this.checkLocked("Cannot invoke #setFile() on a locked JsonWriter!");
        this.reader.setFile(file);
        this.file = file;
        this.contentElement = this.reader.getJsonElement(Throwable::printStackTrace);
        if (this.contentElement.isJsonObject()) {
            this.content = this.reader.getJsonObject();
        }
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public JsonFile getFile() {
        return this.file;
    }

    @Override
    public JsonWriter refresh() {
        return this.setFile(this.file);
    }

    @Override
    public void close() throws IOException {
        if (this.bufferedWriter != null) {
            this.bufferedWriter.close();
        }
    }

    public static JsonWriter of(@NotNull JsonFile file) {
        try {
            return new JsonWriter(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonWriter of(@NotNull JsonFile file, boolean locked) {
        try {
            return new JsonWriter(file, locked);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

