/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.moltenjson.exceptions.JsonParseException;
import net.moltenjson.json.JsonFile;
import net.moltenjson.json.JsonWriter;
import net.moltenjson.json.Refreshable;
import net.moltenjson.utils.Gsons;
import net.moltenjson.utils.JsonUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class JsonURLReader
implements Refreshable<JsonElement> {
    private final URL url;
    private JsonElement content;

    public JsonURLReader(@NotNull URL url) {
        this.url = url;
        this.content = this.parseContent();
    }

    public JsonURLReader(@NotNull String url) throws MalformedURLException {
        this(new URL(url));
    }

    public JsonElement getContentAsElement() {
        return this.content;
    }

    public JsonObject getContentAsObject() {
        return this.content.getAsJsonObject();
    }

    private JsonElement parseContent() {
        try {
            return JsonUtils.getObjectFromString(IOUtils.toString((URL)this.url, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new JsonParseException(e.getMessage());
        }
    }

    @Override
    public JsonElement refresh() {
        this.content = this.parseContent();
        return this.content;
    }

    public void writeToFile(@NotNull JsonFile file, boolean prettyPrinting) throws IOException {
        JsonWriter writer = new JsonWriter(file);
        writer.writeAndOverride((Object)this.getContentAsElement(), prettyPrinting);
        writer.close();
    }

    public <T> T deserializeAs(@NotNull Type type) {
        return this.deserializeAs(type, Gsons.DEFAULT);
    }

    public <T> T deserializeAs(@NotNull Type type, @NotNull Gson gson) {
        return (T)gson.fromJson(this.content, type);
    }

    public <T> T deserialize(@NotNull String key, @NotNull Type type, @NotNull Gson gson) {
        return (T)gson.fromJson(this.content.getAsJsonObject().get(key), type);
    }

    public <T> T deserialize(@NotNull String key, Type type) {
        return this.deserialize(key, type, Gsons.DEFAULT);
    }

    public static JsonURLReader of(@NotNull String url) {
        try {
            return new JsonURLReader(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

