/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.json;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.moltenjson.utils.Gsons;
import net.moltenjson.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;

public class JsonResponse {
    private final String responseText;
    private final JsonObject response;
    private final Gson gson;

    public JsonResponse(@NotNull String response, @NotNull Gson gson) {
        this.responseText = response;
        this.gson = gson;
        this.response = JsonUtils.getObjectFromString(response, this.gson);
    }

    public JsonResponse(@NotNull String response) {
        this(response, Gsons.DEFAULT);
    }

    public <T> T get(@NotNull String key, @NotNull Type type) {
        return (T)this.gson.fromJson(this.response.get(key), type);
    }

    public final String getString(@NotNull String key) {
        return this.response.get(key).getAsString();
    }

    public final int getInt(@NotNull String key) {
        return this.response.get(key).getAsInt();
    }

    public final double getDouble(@NotNull String key) {
        return this.response.get(key).getAsDouble();
    }

    public final long getLong(@NotNull String key) {
        return this.response.get(key).getAsLong();
    }

    public final float getFloat(@NotNull String key) {
        return this.response.get(key).getAsFloat();
    }

    public final boolean getBoolean(@NotNull String key) {
        return this.response.get(key).getAsBoolean();
    }

    public final BigDecimal getBigDecimal(@NotNull String key) {
        return this.response.get(key).getAsBigDecimal();
    }

    public final <E> List<E> getList(@NotNull String key) {
        Type type = new TypeToken<List<E>>(){}.getType();
        return (List)this.get(key, type);
    }

    public final <K, V> Map<K, V> getMap(@NotNull String key) {
        Type type = new TypeToken<LinkedHashMap<K, V>>(){}.getType();
        return (Map)this.get(key, type);
    }

    public String getResponseText() {
        return this.responseText;
    }

    public JsonObject getResponse() {
        return this.response;
    }
}

