/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Consumer;
import net.moltenjson.exceptions.JsonParseException;
import net.moltenjson.json.JsonFile;
import net.moltenjson.json.Lockable;
import net.moltenjson.json.Refreshable;
import net.moltenjson.utils.Gsons;
import net.moltenjson.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonReader
implements Closeable,
Lockable<JsonReader>,
Refreshable<JsonReader> {
    private JsonFile file;
    private final BufferedReader bufferedReader;
    private FileReader fileReader;
    private final boolean inputReader;
    private final boolean locked;

    public JsonReader(@NotNull JsonFile file, boolean locked) throws IOException {
        this.inputReader = false;
        this.file = file;
        this.fileReader = new FileReader(file.getFile());
        this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getFile()), StandardCharsets.UTF_8));
        this.locked = locked;
    }

    public JsonReader(@NotNull JsonFile file) throws IOException {
        this(file, false);
    }

    public JsonReader(@NotNull BufferedReader reader, boolean locked) {
        this.inputReader = true;
        this.bufferedReader = reader;
        this.locked = locked;
    }

    public JsonReader(@NotNull BufferedReader reader) {
        this(reader, false);
    }

    @Override
    public JsonFile getFile() {
        return this.file;
    }

    public <T> T deserializeAs(@NotNull Type type) {
        return this.deserializeAs(type, Gsons.DEFAULT);
    }

    public <T> T deserializeAs(@NotNull Type type, @NotNull Gson gson) {
        Object result = gson.fromJson((Reader)this.bufferedReader, type);
        if (result == null) {
            throw new JsonParseException("Could not parse JSON from file " + this.getFile().getPath() + ". Object to parse: " + type.getTypeName());
        }
        return (T)result;
    }

    public <T> T deserialize(@NotNull String element, @NotNull Type type) {
        return this.deserialize(element, type, Gsons.DEFAULT);
    }

    public <T> T deserialize(@NotNull String element, @NotNull Type type, @NotNull Gson gson) {
        JsonObject object = this.getJsonObject();
        return (T)gson.fromJson(object.get(element), type);
    }

    public JsonObject getJsonObject() {
        return this.getJsonObject(null);
    }

    public JsonObject getJsonObject(@Nullable Consumer<IOException> onError) {
        return this.getJsonElement(onError).getAsJsonObject();
    }

    public JsonElement getJsonElement(Consumer<IOException> onError) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(this.file.getPath(), new String[0]));
            String json = new String(encoded, StandardCharsets.UTF_8);
            return JsonUtils.getElementFromString(json);
        }
        catch (IOException e) {
            if (onError != null) {
                onError.accept(e);
            }
            return null;
        }
    }

    public JsonElement getJsonElement() {
        return this.getJsonElement(null);
    }

    @Override
    public JsonReader setFile(@NotNull JsonFile file) {
        this.checkLocked("Cannot invoke #setFile() on a locked JsonReader!");
        this.file = file;
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void close() throws IOException {
        this.bufferedReader.close();
        if (!this.inputReader) {
            this.fileReader.close();
        }
    }

    public static JsonReader of(@NotNull JsonFile file) {
        try {
            return new JsonReader(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonReader of(@NotNull JsonFile file, boolean locked) {
        try {
            return new JsonReader(file, locked);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JsonReader refresh() {
        return this.setFile(this.file);
    }
}

