/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.json;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class JsonFile {
    private static final byte[] EMPTY_JSON = "{}".getBytes();
    private final File file;
    private final String path;

    public JsonFile(@NotNull File file, boolean createIfNotExist) throws IOException {
        this.file = file;
        this.path = file.getPath();
        this.prepare(createIfNotExist);
    }

    public JsonFile(@NotNull File parent, @NotNull String child, boolean createIfNotExist) throws IOException {
        this.file = new File(parent, child);
        this.path = this.file.getPath();
        this.prepare(createIfNotExist);
    }

    public JsonFile(@NotNull String parent, @NotNull String child, boolean createIfNotExist) throws IOException {
        this.file = new File(parent, child);
        this.path = this.file.getPath();
        this.prepare(createIfNotExist);
    }

    public JsonFile(@NotNull String parent, @NotNull String child) throws IOException {
        this(parent, child, true);
    }

    public JsonFile(@NotNull File file) throws IOException {
        this(file, true);
    }

    public JsonFile(@NotNull File parent, @NotNull String child) throws IOException {
        this(parent, child, true);
    }

    public JsonFile(@NotNull String path, boolean createIfNotExist) throws IOException {
        this(new File(path), createIfNotExist);
    }

    public JsonFile(@NotNull String path) throws IOException {
        this(path, true);
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    private void prepare(boolean create) throws IOException {
        if (!this.file.exists() && create && this.file.createNewFile() || this.file.exists() && JsonFile.isEmpty(FileUtils.readFileToString((File)this.file, (Charset)StandardCharsets.UTF_8).trim())) {
            this.writeCurlyBrackets();
        }
    }

    private void writeCurlyBrackets() {
        try {
            Files.write(Paths.get(this.file.getPath(), new String[0]), EMPTY_JSON, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    private static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static JsonFile of(@NotNull File file) {
        try {
            return new JsonFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonFile of(@NotNull File file, boolean createIfNotExists) {
        try {
            return new JsonFile(file, createIfNotExists);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonFile of(@NotNull String path) {
        try {
            return new JsonFile(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonFile of(@NotNull String path, boolean createIfNotExist) {
        try {
            return new JsonFile(path, createIfNotExist);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonFile of(@NotNull String parent, @NotNull String child, boolean createIfNotExist) {
        try {
            return new JsonFile(parent, child, createIfNotExist);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonFile of(@NotNull String parent, @NotNull String child) {
        try {
            return new JsonFile(parent, child);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonFile of(@NotNull File parent, @NotNull String child) {
        try {
            return new JsonFile(parent, child);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

