/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.configuration.tree;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileFilter;
import net.moltenjson.configuration.tree.TreeConfiguration;
import org.apache.commons.io.FilenameUtils;

public class TreeFileFilter<N, E>
implements FileFilter {
    private ImmutableList<String> exclusionPrefixes;
    private ImmutableList<String> restrictedExtensions;
    private boolean searchSubdirectories;

    public TreeFileFilter(TreeConfiguration<N, E> configuration) {
        this.exclusionPrefixes = configuration.getExclusionPrefixes();
        this.restrictedExtensions = configuration.getRestrictedExtensions();
        this.searchSubdirectories = configuration.searchSubdirectories;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory() && this.searchSubdirectories) {
            return true;
        }
        if (this.exclusionPrefixes.stream().anyMatch(pathname.getName()::startsWith)) {
            return false;
        }
        if (this.restrictedExtensions.isEmpty()) {
            return true;
        }
        return this.restrictedExtensions.stream().anyMatch(FilenameUtils.getExtension((String)pathname.getName())::equals);
    }
}

