/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.configuration.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.moltenjson.configuration.tree.TreeConfiguration;
import net.moltenjson.configuration.tree.strategy.TreeNamingStrategy;
import net.moltenjson.utils.Gsons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeConfigurationBuilder<N, E> {
    private static final ImmutableList<String> EMPTY_LIST = ImmutableList.of();
    private File directory;
    private Gson gson = Gsons.PRETTY_PRINTING;
    private boolean searchSubdirectories = false;
    private boolean lazy = false;
    private Map<N, E> dataMap = new HashMap<N, E>();
    private ImmutableList<String> exclusionPrefixes = EMPTY_LIST;
    private ImmutableList<String> restrictedExtensions = EMPTY_LIST;
    private TreeNamingStrategy<N> namingStrategy;
    private boolean ignoreInvalidFiles;

    public TreeConfigurationBuilder(@NotNull File directory, @NotNull TreeNamingStrategy<N> namingStrategy) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"File is not a directory!");
        this.directory = directory;
        this.namingStrategy = namingStrategy;
    }

    public TreeConfigurationBuilder<N, E> setGson(@Nullable Gson gson) {
        if (gson == null) {
            return this;
        }
        this.gson = gson;
        return this;
    }

    public TreeConfigurationBuilder<N, E> searchSubdirectories() {
        return this.searchSubdirectories(true);
    }

    public TreeConfigurationBuilder<N, E> setLazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    TreeConfigurationBuilder<N, E> searchSubdirectories(boolean searchSubdirectories) {
        this.searchSubdirectories = searchSubdirectories;
        return this;
    }

    public TreeConfigurationBuilder<N, E> setDataMap(@Nullable Map<N, E> map) {
        if (map == null) {
            return this;
        }
        this.dataMap = map;
        return this;
    }

    public TreeConfigurationBuilder<N, E> setExclusionPrefixes(@Nullable ImmutableList<String> prefixes) {
        if (prefixes == null) {
            return this;
        }
        Preconditions.checkArgument((prefixes.size() > 0 ? 1 : 0) != 0, (Object)"Exclusion prefixes must contain at least one element!");
        this.exclusionPrefixes = prefixes;
        return this;
    }

    public TreeConfigurationBuilder<N, E> setRestrictedExtensions(@Nullable ImmutableList<String> extensions) {
        if (extensions == null) {
            return this;
        }
        Preconditions.checkArgument((extensions.size() > 0 ? 1 : 0) != 0, (Object)"Restricted extensions must contain at least one element!");
        this.restrictedExtensions = extensions;
        return this;
    }

    public TreeConfigurationBuilder<N, E> setNamingStrategy(@Nullable TreeNamingStrategy<N> strategy) {
        this.namingStrategy = strategy;
        return this;
    }

    public TreeConfigurationBuilder<N, E> ignoreInvalidFiles(boolean ignoreInvalidFiles) {
        this.ignoreInvalidFiles = ignoreInvalidFiles;
        return this;
    }

    public TreeConfiguration<N, E> build() {
        return new TreeConfiguration<N, E>(this.dataMap, this.directory, this.gson, this.searchSubdirectories, this.exclusionPrefixes, this.restrictedExtensions, this.namingStrategy, this.ignoreInvalidFiles, this.lazy);
    }
}

