/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.configuration.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.moltenjson.configuration.tree.TreeConfigurationBuilder;
import net.moltenjson.configuration.tree.TreeFileFilter;
import net.moltenjson.configuration.tree.strategy.TreeNamingStrategy;
import net.moltenjson.exceptions.InvalidFileException;
import net.moltenjson.json.JsonFile;
import net.moltenjson.json.JsonWriter;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeConfiguration<N, E> {
    private Map<N, E> data;
    private final File directory;
    private final Gson gson;
    final boolean searchSubdirectories;
    private final ImmutableList<String> exclusionPrefixes;
    private final ImmutableList<String> restrictedExtensions;
    private final TreeNamingStrategy<N> namingStrategy;
    private final boolean ignoreInvalidFiles;
    private final boolean lazy;
    private final TreeFileFilter<N, E> fileFilter;
    private boolean dataLoaded = false;
    private Map<String, File> files;
    private JsonWriter writer = null;

    TreeConfiguration(@NotNull Map<N, E> data, @NotNull File directory, @NotNull Gson gson, boolean searchSubdirectories, @NotNull ImmutableList<String> exclusionPrefixes, @NotNull ImmutableList<String> restrictedExtensions, @NotNull TreeNamingStrategy<N> namingStrategy, boolean ignoreInvalidFiles, boolean lazy) {
        this.data = data;
        this.directory = directory;
        this.gson = gson;
        this.searchSubdirectories = searchSubdirectories;
        this.exclusionPrefixes = exclusionPrefixes;
        this.restrictedExtensions = restrictedExtensions;
        this.namingStrategy = namingStrategy;
        this.ignoreInvalidFiles = ignoreInvalidFiles;
        this.lazy = lazy;
        this.fileFilter = new TreeFileFilter(this);
        this.files = this.getIncludedFiles();
    }

    public ImmutableList<String> getExclusionPrefixes() {
        return this.exclusionPrefixes;
    }

    public ImmutableList<String> getRestrictedExtensions() {
        return this.restrictedExtensions;
    }

    public Map<String, File> getFiles() {
        return this.files;
    }

    public Map<N, E> load(@NotNull Type templateType) {
        Preconditions.checkState((!this.lazy ? 1 : 0) != 0, (Object)"Cannot invoke #load(Type) on a lazy TreeConfiguration! Use #lazyLoad(N, Type) instead");
        this.dataLoaded = true;
        this.data.clear();
        for (File file : this.files.values()) {
            try {
                if (this.setFile(file, false) == null) continue;
                N name = this.namingStrategy.fromName(FilenameUtils.getBaseName((String)file.getName()));
                this.data.put(name, this.gson.fromJson(this.writer.getCachedContentAsElement(), templateType));
            }
            catch (InvalidFileException e) {
                if (this.ignoreInvalidFiles) continue;
                throw e;
            }
        }
        return this.data;
    }

    public E lazyLoad(@NotNull N name, @NotNull Type template) {
        Object value = this.data.get(name);
        if (value != null) {
            return value;
        }
        File file = this.files.getOrDefault(this.namingStrategy.toName(name), null);
        if (file == null) {
            return null;
        }
        value = this.gson.fromJson(this.setFile(file, false).getCachedContentAsElement(), template);
        this.data.put(name, value);
        return value;
    }

    public Map<N, E> getData() {
        return this.data;
    }

    public boolean isDataLoaded() {
        return this.dataLoaded;
    }

    public boolean hasData(@NotNull N name) {
        return this.data.containsKey(name);
    }

    public E get(@NotNull N name) {
        return this.data.get(name);
    }

    public E getOrDefault(@NotNull N name, @Nullable E fallback) {
        E value = this.get(name);
        return value == null ? fallback : value;
    }

    public boolean isExclusionPrefix(@NotNull String prefix) {
        return this.exclusionPrefixes.contains((Object)prefix);
    }

    public boolean isExtensionAllowed(@NotNull String extension) {
        return this.restrictedExtensions.contains((Object)extension);
    }

    public E create(@NotNull N name, @NotNull E value, @NotNull String fileExtension) throws IOException {
        this.data.put(name, value);
        Preconditions.checkArgument((this.restrictedExtensions.isEmpty() || this.restrictedExtensions.contains((Object)fileExtension) ? 1 : 0) != 0, (Object)("The specified file extension (\"" + fileExtension + "\") is not one of the allowed extensions (" + this.restrictedExtensions + ")"));
        File file = new File(this.directory, this.namingStrategy.toName(name) + "." + fileExtension);
        this.files.put(this.namingStrategy.toName(name), file);
        this.setFile(file, true).writeAndOverride(this.get(name), this.gson);
        return value;
    }

    public E createIfAbsent(@NotNull N name, @NotNull E value, @NotNull String fileExtension) throws IOException {
        E e = this.get(name);
        if (e == null) {
            e = this.create(name, value, fileExtension);
        }
        return e;
    }

    private Optional<File> removeEntry(@NotNull N name) {
        E value = this.data.remove(name);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(this.files.get(this.namingStrategy.toName(name)));
    }

    public E delete(@NotNull N name) {
        E value = this.data.remove(name);
        if (value == null) {
            return null;
        }
        this.exclude(name).ifPresent(File::delete);
        return value;
    }

    public Optional<File> exclude(@NotNull N name) {
        Optional<File> entryFile = this.removeEntry(name);
        entryFile.ifPresent(this.files::remove);
        return entryFile;
    }

    public Map<N, E> save() throws IOException {
        Preconditions.checkState((!this.lazy ? 1 : 0) != 0, (Object)"Cannot invoke #save() on a lazy TreeConfiguration! Use #lazySave() instead");
        return this.saveNewMap(this.data);
    }

    public Map<N, E> lazySave() throws IOException {
        for (N entry : this.data.keySet()) {
            try {
                File file = this.files.getOrDefault(this.namingStrategy.toName(entry), null);
                this.setFile(file, false);
                N name = this.namingStrategy.fromName(FilenameUtils.getBaseName((String)file.getName()));
                this.writer.writeAndOverride(this.data.get(name), this.gson);
            }
            catch (InvalidFileException e) {
                if (this.ignoreInvalidFiles) continue;
                throw e;
            }
        }
        return this.data;
    }

    public Map<N, E> saveNewMap(@NotNull Map<N, E> data) throws IOException {
        this.data = data;
        for (File file : this.files.values()) {
            try {
                this.setFile(file, false);
                N name = this.namingStrategy.fromName(FilenameUtils.getBaseName((String)file.getName()));
                this.writer.writeAndOverride(data.get(name), this.gson);
            }
            catch (InvalidFileException e) {
                if (this.ignoreInvalidFiles) continue;
                throw e;
            }
        }
        return data;
    }

    private Map<String, File> getIncludedFiles() {
        if (TreeConfiguration.isDirectoryEmpty(this.directory)) {
            return new HashMap<String, File>();
        }
        File[] files = (File[])Preconditions.checkNotNull((Object)this.directory.listFiles(this.fileFilter));
        if (files.length == 0) {
            return new HashMap<String, File>();
        }
        HashMap<String, File> includedFiles = new HashMap<String, File>();
        for (File file : files) {
            if (!file.isDirectory()) {
                includedFiles.put(FilenameUtils.getBaseName((String)file.getName()), file);
                continue;
            }
            if (!this.searchSubdirectories) continue;
            for (File sub : (File[])Preconditions.checkNotNull((Object)file.listFiles(this.fileFilter))) {
                includedFiles.put(FilenameUtils.getBaseName((String)sub.getName()), sub);
            }
        }
        this.files = includedFiles;
        return this.files;
    }

    private JsonWriter setFile(File file, boolean create) throws InvalidFileException {
        try {
            if (this.writer == null) {
                this.writer = new JsonWriter(new JsonFile(file, create));
                return this.writer;
            }
            return this.writer.setFile(new JsonFile(file, create));
        }
        catch (Exception e) {
            if (this.ignoreInvalidFiles) {
                return this.writer;
            }
            throw new InvalidFileException(e, "Failed to parse file " + file.getName() + " in directory " + this.directory.getPath(), file);
        }
    }

    public TreeConfigurationBuilder<N, E> asBuilder() {
        return new TreeConfigurationBuilder<N, E>(this.directory, this.namingStrategy).setDataMap(this.data).setGson(this.gson).searchSubdirectories(this.searchSubdirectories).setExclusionPrefixes(this.exclusionPrefixes).setRestrictedExtensions(this.restrictedExtensions).ignoreInvalidFiles(this.ignoreInvalidFiles);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirectoryEmpty(@NotNull File directory) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory.toPath());){
            boolean empty = !stream.iterator().hasNext();
            stream.close();
            boolean bl = empty;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }
}

