/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.configuration.select;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.Nullable;

public class SelectionHolder<T> {
    private T value;
    private boolean allowNullValues;

    public SelectionHolder(T value, boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
        this.value = allowNullValues ? value : Preconditions.checkNotNull(value, (Object)"Value in the target SelectionHolder may not be null.");
    }

    public SelectionHolder(@Nullable T value) {
        this(value, true);
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = this.allowNullValues ? value : Preconditions.checkNotNull(value, (Object)"Value in the target SelectionHolder may not be null.");
    }

    public String toString() {
        return "SelectionHolder{value=" + this.value + ", allowNullValues=" + this.allowNullValues + '}';
    }
}

