/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.configuration.select;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.moltenjson.configuration.select.Reflector;
import net.moltenjson.configuration.select.SelectKey;
import net.moltenjson.json.JsonFile;
import net.moltenjson.json.JsonWriter;
import net.moltenjson.json.Lockable;
import net.moltenjson.json.Refreshable;
import net.moltenjson.utils.Gsons;
import org.jetbrains.annotations.NotNull;

public class SelectableConfiguration
implements Lockable<SelectableConfiguration>,
Refreshable<SelectableConfiguration> {
    private final JsonWriter writer;
    private JsonObject content;
    private final Map<Class<?>, List<Field>> opted = new HashMap();
    private final boolean classpath;
    private final boolean locked;
    private final Gson gson;

    public SelectableConfiguration(@NotNull JsonFile file, boolean classpath, @NotNull Gson gson, boolean locked) throws IOException {
        this.classpath = classpath;
        JsonFile jsonFile = new JsonFile(file.getFile());
        this.writer = new JsonWriter(jsonFile);
        this.content = this.writer.getCachedContentAsObject();
        this.gson = gson;
        this.locked = locked;
    }

    public SelectableConfiguration(@NotNull JsonFile file, boolean classpath, @NotNull Gson gson) throws IOException {
        this(file, classpath, gson, false);
    }

    public SelectableConfiguration(@NotNull JsonFile file, boolean classpath) throws IOException {
        this(file, classpath, Gsons.DEFAULT);
    }

    public SelectableConfiguration(@NotNull JsonFile file) throws IOException {
        this(file, false, Gsons.PRETTY_PRINTING);
    }

    public final SelectableConfiguration register(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            List<Field> fields = this.opt(clazz);
            if (fields.isEmpty()) {
                return this;
            }
            this.opted.putIfAbsent(clazz, fields);
        }
        return this;
    }

    public final SelectableConfiguration associate() {
        this.opted.forEach((clazz, fields) -> fields.forEach(this::assign));
        return this;
    }

    public final SelectableConfiguration registerAndAssociate(Class<?> ... classes) {
        this.register(classes);
        this.associate();
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public JsonFile getFile() {
        return this.writer.getFile();
    }

    @Override
    public SelectableConfiguration setFile(@NotNull JsonFile file) {
        this.checkLocked("Cannot invoke #setFile() on a locked SelectableConfiguration!");
        this.writer.setFile(file);
        this.content = this.writer.getCachedContentAsObject();
        return this;
    }

    @Override
    public SelectableConfiguration refresh() {
        return this.setFile(this.writer.getFile()).associate();
    }

    public final void remove(@NotNull String key) {
        this.content.remove(key);
    }

    public final void save() {
        try {
            this.opted.forEach((clazz, fields) -> fields.forEach(field -> {
                field.setAccessible(true);
                this.content.add(this.getKey((Field)field), this.gson.toJsonTree(Reflector.getStaticValue(field)));
            }));
            this.writer.writeAndOverride((Object)this.content, this.gson);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Field> opt(Class<?> clazz) {
        if (Arrays.stream(clazz.getDeclaredFields()).noneMatch(f -> f.isAnnotationPresent(SelectKey.class) && Modifier.isStatic(f.getModifiers()))) {
            return Collections.emptyList();
        }
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(SelectKey.class)).collect(Collectors.toList());
    }

    final String getKey(Field field) {
        String name;
        if (!field.isAnnotationPresent(SelectKey.class)) {
            throw new RuntimeException("Found a registered key which is not annotated with @SelectKey! " + field.getDeclaringClass() + "#" + field.getName());
        }
        SelectKey select = field.getAnnotation(SelectKey.class);
        String string = name = select.value().isEmpty() ? field.getName() : select.value();
        if (this.classpath || select.classpath()) {
            name = field.getDeclaringClass().getName() + "." + name;
        }
        return name;
    }

    private void assign(Field field) {
        String key = this.getKey(field);
        if (!this.content.has(key)) {
            this.content.add(key, this.gson.toJsonTree(Reflector.getStaticValue(field)));
            return;
        }
        Object value = Reflector.getValue(this, field);
        Reflector.setStatic(field, value);
        this.content.add(key, this.gson.toJsonTree(value));
    }

    public final JsonObject getContent() {
        return this.content;
    }

    public final boolean isClasspath() {
        return this.classpath;
    }

    public static SelectableConfiguration of(JsonFile file) {
        try {
            return new SelectableConfiguration(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SelectableConfiguration of(JsonFile file, boolean classpath) {
        try {
            return new SelectableConfiguration(file, classpath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SelectableConfiguration of(JsonFile file, boolean classpath, Gson gson) {
        try {
            return new SelectableConfiguration(file, classpath, gson);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SelectableConfiguration of(JsonFile file, boolean classpath, Gson gson, boolean locked) {
        try {
            return new SelectableConfiguration(file, classpath, gson, locked);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

