/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.configuration.select;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.moltenjson.configuration.select.SelectableConfiguration;
import net.moltenjson.configuration.select.SelectionHolder;
import net.moltenjson.utils.Gsons;

class Reflector {
    private Reflector() {
        throw new AssertionError((Object)(Reflector.class.getName() + " cannot be initiated"));
    }

    static void setStatic(Field field, Object value) {
        try {
            field.setAccessible(true);
            if (field.getType().equals(SelectionHolder.class)) {
                Reflector.getSelectionHolder(field).set(value);
                return;
            }
            field.set(field.getDeclaringClass(), value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static Object getValue(SelectableConfiguration configuration, Field field) {
        field.setAccessible(true);
        Type d = field.getType();
        if (d.equals(SelectionHolder.class)) {
            d = Reflector.getGeneric(field);
        }
        return Gsons.DEFAULT.fromJson(configuration.getContent().get(configuration.getKey(field)), d);
    }

    static Object getStaticValue(Field field) {
        try {
            field.setAccessible(true);
            if (field.getType().equals(SelectionHolder.class)) {
                return Reflector.getSelectionHolder(field).get();
            }
            return field.get(field.getDeclaringClass());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static SelectionHolder getSelectionHolder(Field field) {
        try {
            field.setAccessible(true);
            return (SelectionHolder)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Type getGeneric(Field field) {
        field.setAccessible(true);
        ParameterizedType type = (ParameterizedType)field.getGenericType();
        return TypeToken.of((Type)type).resolveType(SelectionHolder.class.getTypeParameters()[0]).getType();
    }
}

