/*
 * Decompiled with CFR 0.152.
 */
package net.moltenjson.configuration.direct;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.moltenjson.json.JsonFile;
import net.moltenjson.json.JsonWriter;
import net.moltenjson.json.Lockable;
import net.moltenjson.json.Refreshable;
import net.moltenjson.utils.Gsons;
import net.moltenjson.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectConfiguration
implements Lockable<DirectConfiguration>,
Refreshable<DirectConfiguration> {
    private final JsonWriter writer;
    private JsonObject content;
    private final boolean locked;

    public DirectConfiguration(@NotNull JsonFile file, boolean locked) throws IOException {
        this.writer = new JsonWriter(file);
        this.locked = locked;
        this.content = this.writer.getCachedContentAsObject();
    }

    public DirectConfiguration(@NotNull JsonFile file) throws IOException {
        this(file, false);
    }

    public final String getString(@NotNull String key) {
        return this.content.get(key).getAsString();
    }

    public final int getInt(@NotNull String key) {
        return this.content.get(key).getAsInt();
    }

    public final double getDouble(@NotNull String key) {
        return this.content.get(key).getAsDouble();
    }

    public final long getLong(@NotNull String key) {
        return this.content.get(key).getAsLong();
    }

    public final float getFloat(@NotNull String key) {
        return this.content.get(key).getAsFloat();
    }

    public final boolean getBoolean(@NotNull String key) {
        return this.content.get(key).getAsBoolean();
    }

    public final BigDecimal getBigDecimal(@NotNull String key) {
        return this.content.get(key).getAsBigDecimal();
    }

    public final List<Object> getList(@NotNull String key) {
        return JsonUtils.toList(this.content.get(key).toString());
    }

    public final Map<String, Object> getMap(@NotNull String key) {
        return JsonUtils.toMap(this.content.get(key).toString());
    }

    public final <T> T get(@NotNull String key, @NotNull Type type) {
        return this.get(key, type, Gsons.PRETTY_PRINTING);
    }

    public final <T> T get(@NotNull String key, @NotNull Type type, @NotNull Gson gson) {
        return (T)gson.fromJson(this.content.get(key), type);
    }

    public final <T> T getAs(@NotNull Type type, @NotNull Gson gson) {
        return (T)gson.fromJson((JsonElement)this.content, type);
    }

    public final <T> T getAs(@NotNull Type type) {
        return this.getAs(type, Gsons.DEFAULT);
    }

    public final JsonObject getContent() {
        return this.content;
    }

    public final void set(@NotNull String key, @Nullable Object value) {
        this.set(key, value == null ? JsonNull.INSTANCE : value, Gsons.PRETTY_PRINTING);
    }

    public final void set(@NotNull String key, @NotNull Object value, @NotNull Gson gson) {
        this.content.add(key, gson.toJsonTree(value));
    }

    public final void remove(@NotNull String key) {
        this.content.remove(key);
    }

    public final void save(@Nullable Consumer<IOException> onException) {
        block2: {
            try {
                this.writer.writeAndOverride((Object)this.content, true);
            }
            catch (IOException e) {
                if (onException == null) break block2;
                onException.accept(e);
            }
        }
    }

    @Override
    public final DirectConfiguration setFile(@NotNull JsonFile file) {
        this.checkLocked("Cannot invoke #setFile() on a locked DirectConfiguration!");
        this.writer.setFile(file);
        this.content = this.writer.getCachedContentAsObject();
        return this;
    }

    @Override
    public final DirectConfiguration refresh() {
        return this.setFile(this.writer.getFile());
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public JsonFile getFile() {
        return this.writer.getFile();
    }

    public static DirectConfiguration of(@NotNull JsonFile file) {
        try {
            return new DirectConfiguration(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DirectConfiguration of(@NotNull JsonFile file, boolean locked) {
        try {
            return new DirectConfiguration(file, locked);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

