/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.tinyloki;

import java.nio.charset.StandardCharsets;
import pl.mjaron.tinyloki.ErrorLogMonitor;
import pl.mjaron.tinyloki.ILogMonitor;

public class VerboseLogMonitor
extends ErrorLogMonitor {
    private String contentType = null;
    private String contentEncoding = null;

    @Override
    public void onConfigured(String contentType, String contentEncoding) {
        ILogMonitor.logInfo("LogController configured.");
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    @Override
    public void onEncoded(byte[] in, byte[] out) {
        ILogMonitor.logInfo("<|> " + in.length + " bytes encoded to " + out.length + " bytes");
    }

    @Override
    public void send(byte[] message) {
        if (this.contentEncoding == null && this.contentType.equals("application/json")) {
            ILogMonitor.logInfo("<<< " + new String(message, StandardCharsets.UTF_8));
        } else {
            ILogMonitor.logInfo("<<< " + message.length + " bytes sent");
        }
    }

    @Override
    public void sendOk(int status) {
        ILogMonitor.logInfo(">>> " + status);
    }

    @Override
    public void onWorkerThreadExit(boolean isSoft) {
        if (isSoft) {
            ILogMonitor.logInfo("Worker thread exited correctly.");
        } else {
            ILogMonitor.logInfo("Worker thread exited by interrupting.");
        }
    }
}

