/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.tinyloki;

import java.util.Map;
import pl.mjaron.tinyloki.ILogStream;
import pl.mjaron.tinyloki.Labels;
import pl.mjaron.tinyloki.LogController;

public class StreamBuilder {
    private final LogController logController;
    private final Labels labels = new Labels();

    public StreamBuilder(LogController logController) {
        this.logController = logController;
    }

    public ILogStream build() {
        return this.logController.createStream(this.labels);
    }

    public Labels getLabels() {
        return this.labels;
    }

    public StreamBuilder l(String labelName, String labelValue) {
        this.labels.l(labelName, labelValue);
        return this;
    }

    public StreamBuilder l(Labels labels) {
        this.labels.l(labels);
        return this;
    }

    public StreamBuilder l(Map<String, String> labels) {
        this.labels.l(labels);
        return this;
    }

    public StreamBuilder critical() {
        this.labels.critical();
        return this;
    }

    public StreamBuilder fatal() {
        this.labels.fatal();
        return this;
    }

    public StreamBuilder warning() {
        this.labels.warning();
        return this;
    }

    public StreamBuilder info() {
        this.labels.info();
        return this;
    }

    public StreamBuilder debug() {
        this.labels.debug();
        return this;
    }

    public StreamBuilder verbose() {
        this.labels.verbose();
        return this;
    }

    public StreamBuilder trace() {
        this.labels.trace();
        return this;
    }

    public StreamBuilder unknown() {
        this.labels.unknown();
        return this;
    }
}

