/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.tinyloki;

import java.util.Map;
import pl.mjaron.tinyloki.ILogCollector;
import pl.mjaron.tinyloki.ILogEncoder;
import pl.mjaron.tinyloki.ILogMonitor;
import pl.mjaron.tinyloki.ILogSender;
import pl.mjaron.tinyloki.ILogStream;
import pl.mjaron.tinyloki.LabelSettings;
import pl.mjaron.tinyloki.Labels;
import pl.mjaron.tinyloki.LogSenderSettings;
import pl.mjaron.tinyloki.StreamBuilder;

public class LogController {
    private static final long LOG_WAIT_TIME = 100L;
    private static final long DEFAULT_SOFT_STOP_WAIT_TIME = 2000L;
    private static final long DEFAULT_HARD_STOP_WAIT_TIME = 1000L;
    private final ILogCollector logCollector;
    private final ILogEncoder logEncoder;
    private final ILogSender logSender;
    private final LabelSettings labelSettings;
    private final ILogMonitor logMonitor;
    private Thread workerThread = null;
    private boolean softFinishing = false;
    private boolean softExit = false;

    public LogController(ILogCollector logCollector, ILogEncoder logEncoder, LogSenderSettings logSenderSettings, ILogSender logSender, LabelSettings labelSettings, ILogMonitor logMonitor) {
        this.logCollector = logCollector;
        this.logEncoder = logEncoder;
        this.logSender = logSender;
        this.labelSettings = labelSettings;
        this.logMonitor = logMonitor;
        logSenderSettings.setContentType(this.logCollector.contentType());
        String contentEncoding = this.logEncoder == null ? null : this.logEncoder.contentEncoding();
        logSenderSettings.setContentEncoding(contentEncoding);
        this.logSender.configure(logSenderSettings, logMonitor);
        this.logMonitor.onConfigured(this.logCollector.contentType(), contentEncoding);
    }

    public LogController(ILogCollector logCollector, LogSenderSettings logSenderSettings, ILogSender logSender, LabelSettings labelSettings, ILogMonitor logMonitor) {
        this(logCollector, null, logSenderSettings, logSender, labelSettings, logMonitor);
    }

    public ILogStream createStream(Map<String, String> labels) {
        return this.createStream(Labels.from(labels));
    }

    public ILogStream createStream(Labels labels) {
        return this.logCollector.createStream(Labels.prettify(labels, this.labelSettings));
    }

    public StreamBuilder stream() {
        return new StreamBuilder(this);
    }

    public LogController start() {
        this.workerThread = new Thread("LogController.workerThread"){

            @Override
            public void run() {
                LogController.this.workerLoop();
            }
        };
        this.workerThread.start();
        return this;
    }

    public synchronized LogController softStopAsync() {
        this.softFinishing = true;
        return this;
    }

    public boolean isHardStopped() {
        return this.workerThread.getState() == Thread.State.TERMINATED;
    }

    public LogController hardStop(long interruptTimeout) {
        try {
            this.softStopAsync();
            this.workerThread.interrupt();
            this.workerThread.join(interruptTimeout);
        }
        catch (InterruptedException e) {
            this.logMonitor.onException(e);
        }
        return this;
    }

    public LogController hardStop() {
        return this.hardStop(1000L);
    }

    public LogController softStop(long softTimeout) {
        try {
            this.softStopAsync();
            this.workerThread.join(softTimeout);
        }
        catch (InterruptedException e) {
            this.logMonitor.onException(e);
        }
        return this;
    }

    public LogController softStop() {
        return this.softStop(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSoftStopped() {
        LogController logController = this;
        synchronized (logController) {
            return this.softExit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workerLoop() {
        while (true) {
            try {
                boolean doLastCheck;
                do {
                    byte[] logs;
                    doLastCheck = false;
                    LogController logController = this;
                    synchronized (logController) {
                        if (this.softFinishing) {
                            doLastCheck = true;
                        }
                    }
                    int anyLogs = doLastCheck ? this.logCollector.waitForLogs(1L) : this.logCollector.waitForLogs(100L);
                    if (anyLogs <= 0 || (logs = this.logCollector.collect()) == null) continue;
                    if (this.logEncoder != null) {
                        byte[] encodedLogs = this.logEncoder.encode(logs);
                        this.logMonitor.onEncoded(logs, encodedLogs);
                        this.logSender.send(encodedLogs);
                        continue;
                    }
                    this.logSender.send(logs);
                } while (!doLastCheck);
                LogController logController = this;
                synchronized (logController) {
                    this.softExit = true;
                }
                this.logMonitor.onWorkerThreadExit(true);
                return;
            }
            catch (InterruptedException e) {
                this.logMonitor.onException(e);
                this.logMonitor.onWorkerThreadExit(false);
                return;
            }
            catch (Exception e) {
                this.logMonitor.onException(e);
                continue;
            }
            break;
        }
    }
}

