/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.common.npc;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.NpcTracker;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.event.HideNpcEvent;
import com.github.juliarn.npclib.api.event.NpcEvent;
import com.github.juliarn.npclib.api.event.ShowNpcEvent;
import com.github.juliarn.npclib.api.flag.NpcFlag;
import com.github.juliarn.npclib.api.profile.Profile;
import com.github.juliarn.npclib.api.protocol.NpcSpecificOutboundPacket;
import com.github.juliarn.npclib.api.protocol.enums.EntityAnimation;
import com.github.juliarn.npclib.api.protocol.enums.ItemSlot;
import com.github.juliarn.npclib.api.protocol.enums.PlayerInfoAction;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import com.github.juliarn.npclib.api.settings.NpcSettings;
import com.github.juliarn.npclib.api.util.Util;
import com.github.juliarn.npclib.common.event.DefaultHideNpcEvent;
import com.github.juliarn.npclib.common.event.DefaultShowNpcEvent;
import com.github.juliarn.npclib.common.flag.CommonNpcFlaggedObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class CommonNpc<W, P, I, E>
extends CommonNpcFlaggedObject
implements Npc<W, P, I, E> {
    protected final int entityId;
    protected final Profile.Resolved profile;
    protected final W world;
    protected final Position pos;
    protected final Platform<W, P, I, E> platform;
    protected final NpcSettings<P> npcSettings;
    protected final Set<P> trackedPlayers = Collections.synchronizedSet(new HashSet());
    protected final Set<P> includedPlayers = Collections.synchronizedSet(new HashSet());

    public CommonNpc(@NotNull Map<NpcFlag<?>, Optional<?>> flags, int entityId, @NotNull Profile.Resolved profile, @NotNull W world, @NotNull Position pos, @NotNull Platform<W, P, I, E> platform, @NotNull NpcSettings<P> npcSettings) {
        super(flags);
        this.entityId = entityId;
        this.profile = profile;
        this.world = world;
        this.pos = pos;
        this.platform = platform;
        this.npcSettings = npcSettings;
    }

    public int entityId() {
        return this.entityId;
    }

    @NotNull
    public Profile.Resolved profile() {
        return this.profile;
    }

    @NotNull
    public W world() {
        return this.world;
    }

    @NotNull
    public Position position() {
        return this.pos;
    }

    @NotNull
    public NpcSettings<P> settings() {
        return this.npcSettings;
    }

    @NotNull
    public Platform<W, P, I, E> platform() {
        return this.platform;
    }

    @NotNull
    public NpcTracker<W, P, I, E> npcTracker() {
        return this.platform.npcTracker();
    }

    public boolean shouldIncludePlayer(@NotNull P player) {
        return this.npcSettings.trackingRule().shouldTrack((Npc)this, player);
    }

    public @UnmodifiableView @NotNull Collection<P> includedPlayers() {
        return Collections.unmodifiableSet(this.includedPlayers);
    }

    public boolean includesPlayer(@NotNull P player) {
        return this.includedPlayers.contains(player);
    }

    @NotNull
    public Npc<W, P, I, E> addIncludedPlayer(@NotNull P player) {
        this.includedPlayers.add(player);
        return this;
    }

    @NotNull
    public Npc<W, P, I, E> removeIncludedPlayer(@NotNull P player) {
        this.includedPlayers.remove(player);
        return this;
    }

    @NotNull
    public Npc<W, P, I, E> unlink() {
        Object[] players;
        this.npcTracker().stopTrackingNpc((Npc)this);
        for (Object player : players = this.trackedPlayers.toArray()) {
            this.stopTrackingPlayer(player);
        }
        return this;
    }

    public @UnmodifiableView @NotNull Collection<P> trackedPlayers() {
        return Collections.unmodifiableSet(this.trackedPlayers);
    }

    public boolean tracksPlayer(@NotNull P player) {
        return this.trackedPlayers.contains(player);
    }

    @NotNull
    public Npc<W, P, I, E> trackPlayer(@NotNull P player) {
        if (this.shouldIncludePlayer(player)) {
            return this.forceTrackPlayer(player);
        }
        return this;
    }

    @NotNull
    public Npc<W, P, I, E> forceTrackPlayer(@NotNull P player) {
        if (!this.trackedPlayers.contains(player)) {
            if (((ShowNpcEvent.Pre)this.platform.eventManager().post((NpcEvent)DefaultShowNpcEvent.pre(this, player))).cancelled()) {
                return this;
            }
            if (!this.trackedPlayers.add(player)) {
                return this;
            }
            this.platform.packetFactory().createPlayerInfoPacket(PlayerInfoAction.ADD_PLAYER).schedule(player, (Npc)this);
            this.platform.taskManager().scheduleDelayedAsync(() -> {
                this.platform.packetFactory().createEntitySpawnPacket().schedule(player, (Npc)this);
                this.platform.eventManager().post((NpcEvent)DefaultShowNpcEvent.post(this, player));
            }, 10);
        }
        return this;
    }

    @NotNull
    public Npc<W, P, I, E> stopTrackingPlayer(@NotNull P player) {
        if (this.trackedPlayers.contains(player)) {
            if (((HideNpcEvent.Pre)this.platform.eventManager().post((NpcEvent)DefaultHideNpcEvent.pre(this, player))).cancelled()) {
                return this;
            }
            if (!this.trackedPlayers.remove(player)) {
                return this;
            }
            this.platform.packetFactory().createEntityRemovePacket().schedule(player, (Npc)this);
            this.platform.packetFactory().createPlayerInfoPacket(PlayerInfoAction.REMOVE_PLAYER).schedule(player, (Npc)this);
            this.platform.eventManager().post((NpcEvent)DefaultHideNpcEvent.post(this, player));
        }
        return this;
    }

    @NotNull
    public NpcSpecificOutboundPacket<W, P, I, E> rotate(float yaw, float pitch) {
        return this.platform.packetFactory().createRotationPacket(yaw, pitch).toSpecific((Npc)this);
    }

    @NotNull
    public NpcSpecificOutboundPacket<W, P, I, E> lookAt(@NotNull Position position) {
        double diffX = position.x() - this.pos.x();
        double diffY = position.y() - this.pos.y();
        double diffZ = position.z() - this.pos.z();
        double distanceXZ = Math.sqrt(diffX * diffX + diffZ * diffZ);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + diffY * diffY);
        double yaw = Math.toDegrees(Math.acos(diffX / distanceXZ));
        double pitch = Math.toDegrees(Math.acos(diffY / distanceY)) - 90.0;
        if (diffZ < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        return this.platform.packetFactory().createRotationPacket((float)(yaw -= 90.0), (float)pitch).toSpecific((Npc)this);
    }

    @NotNull
    public NpcSpecificOutboundPacket<W, P, I, E> playAnimation(@NotNull EntityAnimation animation) {
        return this.platform.packetFactory().createAnimationPacket(animation).toSpecific((Npc)this);
    }

    @NotNull
    public NpcSpecificOutboundPacket<W, P, I, E> changeItem(@NotNull ItemSlot slot, @NotNull I item) {
        return this.platform.packetFactory().createEquipmentPacket(slot, item).toSpecific((Npc)this);
    }

    @NotNull
    public <T, O> NpcSpecificOutboundPacket<W, P, I, E> changeMetadata(@NotNull EntityMetadataFactory<T, O> metadata, @NotNull T value) {
        return this.platform.packetFactory().createEntityMetaPacket(metadata, value).toSpecific((Npc)this);
    }

    public int hashCode() {
        return Integer.hashCode(this.entityId());
    }

    public boolean equals(Object obj) {
        return Util.equals(Npc.class, (Object)this, (Object)obj, (orig, comp) -> orig.entityId() == comp.entityId());
    }
}

