/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.bukkit;

import com.github.juliarn.npclib.api.PlatformWorldAccessor;
import io.papermc.lib.PaperLib;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitWorldAccessor {
    private BukkitWorldAccessor() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static PlatformWorldAccessor<World> worldAccessor() {
        if (PaperLib.isPaper() && PaperLib.isVersion((int)16, (int)5)) {
            return ModernAccessor.INSTANCE;
        }
        return LegacyAccessor.INSTANCE;
    }

    @NotNull
    public static PlatformWorldAccessor<World> nameBasedAccessor() {
        return LegacyAccessor.INSTANCE;
    }

    @NotNull
    public static PlatformWorldAccessor<World> keyBasedAccessor() {
        return ModernAccessor.INSTANCE;
    }

    private static final class ModernAccessor
    implements PlatformWorldAccessor<World> {
        private static final PlatformWorldAccessor<World> INSTANCE = new ModernAccessor();

        private ModernAccessor() {
        }

        @NotNull
        public String extractWorldIdentifier(@NotNull World world) {
            return world.getKey().toString();
        }

        @Nullable
        public World resolveWorldFromIdentifier(@NotNull String identifier) {
            NamespacedKey key = NamespacedKey.fromString((String)identifier);
            return key == null ? null : Bukkit.getWorld((NamespacedKey)key);
        }
    }

    private static final class LegacyAccessor
    implements PlatformWorldAccessor<World> {
        private static final PlatformWorldAccessor<World> INSTANCE = new LegacyAccessor();

        private LegacyAccessor() {
        }

        @NotNull
        public String extractWorldIdentifier(@NotNull World world) {
            return world.getName();
        }

        @Nullable
        public World resolveWorldFromIdentifier(@NotNull String identifier) {
            return Bukkit.getWorld((String)identifier);
        }
    }
}

