/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.profile;

import com.github.juliarn.npclib.api.profile.Profile;
import com.github.juliarn.npclib.api.profile.ProfileProperty;
import com.github.juliarn.npclib.api.util.Util;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultResolvedProfile
implements Profile.Resolved {
    private final String name;
    private final UUID uniqueId;
    private final Set<ProfileProperty> properties;

    DefaultResolvedProfile(@NotNull String name, @NotNull UUID uniqueId, @NotNull Set<ProfileProperty> properties) {
        this.name = name;
        this.uniqueId = uniqueId;
        this.properties = properties.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(properties);
    }

    private DefaultResolvedProfile(@NotNull String name, @NotNull UUID uniqueId, @NotNull Set<ProfileProperty> properties, @Nullable Void ignored) {
        this.name = name;
        this.uniqueId = uniqueId;
        this.properties = properties;
    }

    @Override
    @NotNull
    public Set<ProfileProperty> properties() {
        return this.properties;
    }

    @Override
    @NotNull
    public UUID uniqueId() {
        return this.uniqueId;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public Profile.Resolved withName(@NotNull String name) {
        return new DefaultResolvedProfile(name, this.uniqueId, this.properties, null);
    }

    @Override
    @NotNull
    public Profile.Resolved withUniqueId(@NotNull UUID uniqueId) {
        return new DefaultResolvedProfile(this.name, uniqueId, this.properties, null);
    }

    @Override
    @NotNull
    public Profile.Resolved withoutProperties() {
        return new DefaultResolvedProfile(this.name, this.uniqueId, Collections.emptySet());
    }

    @Override
    @NotNull
    public Profile.Resolved withProperty(@NotNull ProfileProperty property) {
        Objects.requireNonNull(property, "property");
        HashSet<ProfileProperty> propertySet = new HashSet<ProfileProperty>(this.properties);
        propertySet.add(property);
        return new DefaultResolvedProfile(this.name, this.uniqueId, propertySet);
    }

    @Override
    @NotNull
    public Profile.Resolved withProperties(@NotNull Set<ProfileProperty> properties) {
        return new DefaultResolvedProfile(this.name, this.uniqueId, new HashSet<ProfileProperty>(properties));
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uniqueId, this.properties);
    }

    public boolean equals(Object obj) {
        return Util.equals(Profile.Resolved.class, this, obj, (orig, comp) -> orig.name().equals(comp.name()) && orig.uniqueId().equals(comp.uniqueId()) && orig.properties().equals(comp.properties()));
    }
}

