/*
 * Decompiled with CFR 0.152.
 */
package com.wl;

import com.wl.IntLotteryDelegator;
import com.wl.UniformLottery;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;

public class PartialSumsTree
implements IntLotteryDelegator {
    private final double[] tree;
    private final double[] weights;
    private final boolean[] selected;
    private final int n;
    private final ThreadLocalRandom random;
    private int size;

    public PartialSumsTree(double[] weights, boolean[] selected, int size, ThreadLocalRandom random) {
        int left;
        int i;
        this.n = weights.length;
        this.tree = new double[this.n + 2 - this.n % 2];
        int firstLeafIndex = this.n >> 1;
        System.arraycopy(weights, firstLeafIndex, this.tree, 1 + firstLeafIndex, this.n - firstLeafIndex);
        for (i = this.n >> 1; i > this.n >> 2; --i) {
            left = i << 1;
            this.tree[i] = this.verify(weights[i - 1]) + this.verify(this.tree[left]) + this.verify(this.tree[left + 1]);
        }
        for (i = this.n >> 2; i > 0; --i) {
            left = i << 1;
            this.tree[i] = this.verify(weights[i - 1]) + this.tree[left] + this.tree[left + 1];
        }
        this.random = random;
        this.size = size;
        this.weights = weights;
        this.selected = selected;
    }

    private double verify(double weight) {
        if (!(weight >= 0.0)) {
            throw new IllegalArgumentException("weights contain invalid weight: " + weight);
        }
        return weight;
    }

    @Override
    public int draw() {
        if (this.tree[1] <= 0.0) {
            return -1;
        }
        double r = this.random.nextDouble(this.tree[1]);
        int root = 1;
        while (root <= this.n >> 1) {
            int left = root << 1;
            if (r < this.tree[left]) {
                root = left;
                continue;
            }
            int right = left + 1;
            double leftAndRootWeight = this.tree[root] - this.tree[right];
            if (!(r >= leftAndRootWeight)) break;
            r -= leftAndRootWeight;
            root = right;
        }
        if (this.selected[root - 1]) {
            return -1;
        }
        this.remove(root);
        return root - 1;
    }

    private void remove(int root) {
        double rootWeight = this.weights[root - 1];
        this.selected[root - 1] = true;
        while (root >= 1) {
            int n = root;
            this.tree[n] = this.tree[n] - rootWeight;
            root >>= 1;
        }
        --this.size;
    }

    @Override
    public boolean empty() {
        return this.size == 0;
    }

    @Override
    public int remaining() {
        return this.size;
    }

    @Override
    public IntLotteryDelegator delegate() {
        int numZeros = 0;
        int[] zeroWeightsIndexes = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            if (this.selected[i] || this.weights[i] != 0.0) continue;
            zeroWeightsIndexes[numZeros++] = i;
            if (numZeros != this.size) continue;
            return new UniformLottery(zeroWeightsIndexes, this.size, this.random);
        }
        double[] selectedWeightsZeroed = Arrays.copyOf(this.weights, this.n);
        for (int i = 0; i < this.n; ++i) {
            if (!this.selected[i]) continue;
            selectedWeightsZeroed[i] = 0.0;
        }
        return new PartialSumsTree(selectedWeightsZeroed, this.selected, this.size, this.random);
    }
}

