/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.webapi;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.internal.Utils;

public final class Info {
    private static Info INSTANCE;
    @SerializedName(value="mirai")
    public HashMap<String, String> mirai;
    @SerializedName(value="announcement")
    public List<String> announcement;
    @SerializedName(value="apis")
    public List<String> apis;

    public Info() {
        INSTANCE = this;
    }

    public static Info init() throws IOException {
        return Info.init(Collections.singletonList("https://api.miraimc.dreamvoid.me/"), true);
    }

    public static Info init(List<String> apis, boolean LocalCache) throws IOException {
        if (INSTANCE == null) {
            ArrayList<String> list = new ArrayList<String>(apis);
            File CacheDir = new File(Config.PluginDir, "cache");
            if (!CacheDir.exists() && !CacheDir.mkdirs()) {
                throw new RuntimeException("Failed to create folder " + CacheDir.getPath());
            }
            File cache = new File(CacheDir, "apis.json");
            if (LocalCache) {
                try {
                    if (!cache.exists()) {
                        try (InputStream in = Info.class.getResourceAsStream("/apis.json");){
                            assert (in != null);
                            Files.copy(in, cache.toPath(), new CopyOption[0]);
                        }
                    }
                    String[] localString = (String[])new Gson().fromJson((Reader)new FileReader(cache), String[].class);
                    ArrayList<String> local = new ArrayList<String>(Arrays.asList(localString));
                    local.removeAll(list);
                    list.addAll(local);
                }
                catch (Exception localString) {
                    // empty catch block
                }
            }
            IOException e = null;
            for (String s : list) {
                if (!s.endsWith("/")) {
                    s = s + "/";
                }
                try {
                    INSTANCE = (Info)new Gson().fromJson(Utils.Http.get(s + "info.json"), Info.class);
                    FileOutputStream fos = new FileOutputStream(cache);
                    fos.write(new Gson().toJson((Object)Info.INSTANCE.apis.toArray(), String[].class).getBytes(StandardCharsets.UTF_8));
                    fos.close();
                    break;
                }
                catch (IOException ex) {
                    Utils.logger.warning("Failed to get " + s + ", reason: " + ex);
                    if (e != null) continue;
                    e = ex;
                }
            }
            if (INSTANCE == null) {
                assert (e != null);
                throw e;
            }
        }
        return INSTANCE;
    }
}

