/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.libraries.org.slf4j.event;

import java.util.Queue;
import me.dreamvoid.miraimc.libraries.org.slf4j.Marker;
import me.dreamvoid.miraimc.libraries.org.slf4j.event.Level;
import me.dreamvoid.miraimc.libraries.org.slf4j.event.SubstituteLoggingEvent;
import me.dreamvoid.miraimc.libraries.org.slf4j.helpers.LegacyAbstractLogger;
import me.dreamvoid.miraimc.libraries.org.slf4j.helpers.SubstituteLogger;

public class EventRecodingLogger
extends LegacyAbstractLogger {
    private static final long serialVersionUID = -176083308134819629L;
    String name;
    SubstituteLogger logger;
    Queue<SubstituteLoggingEvent> eventQueue;
    static final boolean RECORD_ALL_EVENTS = true;

    public EventRecodingLogger(SubstituteLogger logger, Queue<SubstituteLoggingEvent> eventQueue) {
        this.logger = logger;
        this.name = logger.getName();
        this.eventQueue = eventQueue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    protected void handleNormalizedLoggingCall(Level level, Marker marker, String msg, Object[] args, Throwable throwable) {
        SubstituteLoggingEvent loggingEvent = new SubstituteLoggingEvent();
        loggingEvent.setTimeStamp(System.currentTimeMillis());
        loggingEvent.setLevel(level);
        loggingEvent.setLogger(this.logger);
        loggingEvent.setLoggerName(this.name);
        if (marker != null) {
            loggingEvent.addMarker(marker);
        }
        loggingEvent.setMessage(msg);
        loggingEvent.setThreadName(Thread.currentThread().getName());
        loggingEvent.setArgumentArray(args);
        loggingEvent.setThrowable(throwable);
        this.eventQueue.add(loggingEvent);
    }

    @Override
    protected String getFullyQualifiedCallerName() {
        return null;
    }
}

