/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.libraries.org.apache.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpException;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpHost;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpRequest;
import me.dreamvoid.miraimc.libraries.org.apache.http.annotation.Contract;
import me.dreamvoid.miraimc.libraries.org.apache.http.annotation.ThreadingBehavior;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.ClientProtocolException;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.config.RequestConfig;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.methods.CloseableHttpResponse;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.methods.Configurable;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.methods.HttpExecutionAware;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.methods.HttpRequestWrapper;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.protocol.HttpClientContext;
import me.dreamvoid.miraimc.libraries.org.apache.http.conn.ClientConnectionManager;
import me.dreamvoid.miraimc.libraries.org.apache.http.conn.ClientConnectionRequest;
import me.dreamvoid.miraimc.libraries.org.apache.http.conn.HttpClientConnectionManager;
import me.dreamvoid.miraimc.libraries.org.apache.http.conn.ManagedClientConnection;
import me.dreamvoid.miraimc.libraries.org.apache.http.conn.routing.HttpRoute;
import me.dreamvoid.miraimc.libraries.org.apache.http.conn.scheme.SchemeRegistry;
import me.dreamvoid.miraimc.libraries.org.apache.http.impl.DefaultConnectionReuseStrategy;
import me.dreamvoid.miraimc.libraries.org.apache.http.impl.client.CloseableHttpClient;
import me.dreamvoid.miraimc.libraries.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import me.dreamvoid.miraimc.libraries.org.apache.http.impl.execchain.MinimalClientExec;
import me.dreamvoid.miraimc.libraries.org.apache.http.params.BasicHttpParams;
import me.dreamvoid.miraimc.libraries.org.apache.http.params.HttpParams;
import me.dreamvoid.miraimc.libraries.org.apache.http.protocol.BasicHttpContext;
import me.dreamvoid.miraimc.libraries.org.apache.http.protocol.HttpContext;
import me.dreamvoid.miraimc.libraries.org.apache.http.protocol.HttpRequestExecutor;
import me.dreamvoid.miraimc.libraries.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

