/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.libraries.org.apache.http.impl;

import java.util.Locale;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpResponse;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpResponseFactory;
import me.dreamvoid.miraimc.libraries.org.apache.http.ProtocolVersion;
import me.dreamvoid.miraimc.libraries.org.apache.http.ReasonPhraseCatalog;
import me.dreamvoid.miraimc.libraries.org.apache.http.StatusLine;
import me.dreamvoid.miraimc.libraries.org.apache.http.annotation.Contract;
import me.dreamvoid.miraimc.libraries.org.apache.http.annotation.ThreadingBehavior;
import me.dreamvoid.miraimc.libraries.org.apache.http.impl.EnglishReasonPhraseCatalog;
import me.dreamvoid.miraimc.libraries.org.apache.http.message.BasicHttpResponse;
import me.dreamvoid.miraimc.libraries.org.apache.http.message.BasicStatusLine;
import me.dreamvoid.miraimc.libraries.org.apache.http.protocol.HttpContext;
import me.dreamvoid.miraimc.libraries.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

