/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.internal.classloader;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.xml.parsers.ParserConfigurationException;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.internal.Utils;
import me.dreamvoid.miraimc.internal.classloader.LibrariesLoader;
import me.dreamvoid.miraimc.webapi.Info;
import me.dreamvoid.miraimc.webapi.Version;
import org.xml.sax.SAXException;

public class MiraiLoader {
    public static void loadMiraiCore() throws RuntimeException, IOException, ParserConfigurationException, SAXException {
        MiraiLoader.loadMiraiCore(LibrariesLoader.getLibraryVersionMaven("net.mamoe", "mirai-core-all", Config.General.MavenRepoUrl.replace("http://", "https://"), "release"));
    }

    public static String getStableVersion() {
        try {
            return Info.init().mirai.get("stable");
        }
        catch (IOException e) {
            Utils.logger.warning("Fetching mirai stable version from remote failed, try to use latest. Reason: " + e);
            return "latest";
        }
    }

    public static String getStableVersion(String PluginVersion) {
        try {
            String mirai = Info.init().mirai.get("stable");
            try {
                int ver = Version.init().versions.getOrDefault(PluginVersion, 0);
                int temp = -1;
                for (String s : Info.init().mirai.keySet()) {
                    if (s.equalsIgnoreCase("stable") || ver > Integer.parseInt(s) || Integer.parseInt(s) <= temp) continue;
                    mirai = Info.init().mirai.get(s);
                    temp = Integer.parseInt(s);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mirai;
        }
        catch (IOException e) {
            Utils.logger.warning("Fetching mirai stable version from remote failed, try to use latest. Reason: " + e);
            return "latest";
        }
    }

    public static void loadMiraiCore(String version) throws RuntimeException, IOException, ParserConfigurationException, SAXException {
        File MiraiDir;
        File LibrariesDir;
        if (version.equalsIgnoreCase("latest")) {
            version = LibrariesLoader.getLibraryVersionMaven("net.mamoe", "mirai-core-all", Config.General.MavenRepoUrl.replace("http://", "https://"), "release");
        }
        if (!(LibrariesDir = new File(MiraiDir = Config.General.MiraiWorkingDir.equals("default") ? new File(Config.PluginDir, "MiraiBot") : new File(Config.General.MiraiWorkingDir), "libs")).exists() && !LibrariesDir.mkdirs()) {
            throw new RuntimeException("Failed to create " + LibrariesDir.getPath());
        }
        File writeName = new File(new File(Config.PluginDir, "cache"), "core-ver");
        if (!writeName.getParentFile().exists() && !writeName.getParentFile().mkdirs()) {
            throw new RuntimeException("Failed to create " + writeName.getParentFile().getPath());
        }
        try {
            LibrariesLoader.loadLibraryClassMaven("net.mamoe", "mirai-core-all", version, "-all", Config.General.MavenRepoUrl.replace("http://", "https://"), LibrariesDir);
            try (FileWriter writer = new FileWriter(writeName);
                 BufferedWriter out = new BufferedWriter(writer);){
                out.write(version);
                out.flush();
            }
        }
        catch (Exception e) {
            Utils.logger.warning("Unable to download mirai core from remote server(" + e + "), try to use local core.");
            if (writeName.exists()) {
                String content = new String(Files.readAllBytes(writeName.toPath()), StandardCharsets.UTF_8);
                if (!content.equals("")) {
                    String name = "mirai-core-all-" + content + ".jar";
                    File coreFile = new File(LibrariesDir, name);
                    LibrariesLoader.loadLibraryClassLocal(coreFile);
                } else {
                    Utils.logger.warning("Unable to use local core.");
                }
            }
            Utils.logger.warning("No local core found.");
        }
    }
}

