/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.coroutines.Continuation;
import me.dreamvoid.miraimc.internal.Config;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.network.CustomLoginFailedException;
import net.mamoe.mirai.utils.LoginSolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiraiLoginSolver
extends LoginSolver {
    private Thread threads;
    private static final List<Bot> deviceVerifyWait = new ArrayList<Bot>();
    private static final HashMap<Bot, String> deviceVerifyCode = new HashMap();
    private final CustomLoginFailedException loginCancelException = new CustomLoginFailedException(true, "\u7528\u6237\u7ec8\u6b62\u767b\u5f55"){};
    private final CustomLoginFailedException loginErrorException = new CustomLoginFailedException(true, "\u767b\u5f55\u65f6\u51fa\u73b0\u4e25\u91cd\u9519\u8bef"){};

    @Nullable
    public String onSolvePicCaptcha(@NotNull Bot bot, byte[] imageData, @NotNull Continuation<? super String> continuation) {
        File ImageDir = new File(Config.PluginDir, "verify-image");
        if (!ImageDir.exists() && !ImageDir.mkdirs()) {
            throw new RuntimeException("Failed to create folder " + ImageDir.getPath());
        }
        File imageFile = new File(ImageDir, bot.getId() + "-verify.png");
        try (OutputStream fos = Files.newOutputStream(imageFile.toPath(), new OpenOption[0]);){
            fos.write(imageData);
            fos.flush();
        }
        catch (IOException e) {
            bot.getLogger().warning("\u4fdd\u5b58\u9a8c\u8bc1\u7801\u56fe\u7247\u6587\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
        }
        try {
            this.threads = new Thread(() -> {
                deviceVerifyWait.add(bot);
                bot.getLogger().warning("\u5f53\u524d\u767b\u5f55\u7684QQ\uff08" + bot.getId() + "\uff09\u9700\u8981\u6587\u5b57\u9a8c\u8bc1\u7801\u9a8c\u8bc1");
                bot.getLogger().warning("\u8bf7\u627e\u5230\u4e0b\u9762\u7684\u6587\u4ef6\u5e76\u8bc6\u522b\u6587\u5b57\u9a8c\u8bc1\u7801");
                bot.getLogger().warning(imageFile.getPath());
                bot.getLogger().warning("\u8bc6\u522b\u5b8c\u6210\u540e\uff0c\u8bf7\u8f93\u5165\u6307\u4ee4 /miraiverify captcha " + bot.getId() + " <\u9a8c\u8bc1\u7801>");
                bot.getLogger().warning("\u5982\u9700\u53d6\u6d88\u767b\u5f55\uff0c\u8bf7\u8f93\u5165\u6307\u4ee4 /miraiverify cancel " + bot.getId());
                bot.getLogger().warning("\u5982\u9700\u5e2e\u52a9\uff0c\u8bf7\u53c2\u9605: https://wiki.miraimc.dreamvoid.me/troubleshoot/verify-guide#word-captcha");
                while (deviceVerifyWait.contains(bot) && !deviceVerifyCode.containsKey(bot)) {
                }
            });
            this.threads.start();
            this.threads.join();
        }
        catch (IllegalThreadStateException | InterruptedException e) {
            bot.getLogger().warning("\u542f\u52a8\u9a8c\u8bc1\u7ebf\u7a0b\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
            throw this.loginErrorException;
        }
        if (deviceVerifyCode.containsKey(bot)) {
            String result = deviceVerifyCode.get(bot);
            deviceVerifyWait.remove(bot);
            deviceVerifyCode.remove(bot);
            return result;
        }
        deviceVerifyWait.remove(bot);
        deviceVerifyCode.remove(bot);
        throw this.loginCancelException;
    }

    @Nullable
    public String onSolveSliderCaptcha(@NotNull Bot bot, @NotNull String verifyUrl, @NotNull Continuation<? super String> continuation) {
        try {
            this.threads = new Thread(() -> {
                deviceVerifyWait.add(bot);
                bot.getLogger().warning("\u5f53\u524d\u767b\u5f55\u7684QQ\uff08" + bot.getId() + "\uff09\u9700\u8981\u6ed1\u52a8\u9a8c\u8bc1\u7801\u9a8c\u8bc1");
                bot.getLogger().warning("\u8bf7\u6253\u5f00\u4ee5\u4e0b\u94fe\u63a5\u8fdb\u884c\u9a8c\u8bc1");
                bot.getLogger().warning(verifyUrl);
                bot.getLogger().warning("\u9a8c\u8bc1\u5b8c\u6210\u540e\uff0c\u8bf7\u8f93\u5165\u6307\u4ee4 /miraiverify captcha " + bot.getId() + " <ticket>");
                bot.getLogger().warning("\u5982\u9700\u53d6\u6d88\u767b\u5f55\uff0c\u8bf7\u8f93\u5165\u6307\u4ee4 /miraiverify cancel " + bot.getId());
                bot.getLogger().warning("\u5982\u9700\u5e2e\u52a9\uff0c\u8bf7\u53c2\u9605: https://wiki.miraimc.dreamvoid.me/troubleshoot/verify-guide#slide-captcha");
                while (deviceVerifyWait.contains(bot) && !deviceVerifyCode.containsKey(bot)) {
                }
            });
            this.threads.start();
            this.threads.join();
        }
        catch (IllegalThreadStateException | InterruptedException e) {
            bot.getLogger().warning("\u542f\u52a8\u9a8c\u8bc1\u7ebf\u7a0b\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
            throw this.loginErrorException;
        }
        if (deviceVerifyCode.containsKey(bot)) {
            String result = deviceVerifyCode.get(bot);
            deviceVerifyWait.remove(bot);
            deviceVerifyCode.remove(bot);
            return result;
        }
        deviceVerifyWait.remove(bot);
        deviceVerifyCode.remove(bot);
        throw this.loginCancelException;
    }

    @Nullable
    public Object onSolveUnsafeDeviceLoginVerify(@NotNull Bot bot, @NotNull String verifyUrl, @NotNull Continuation<? super String> continuation) {
        try {
            this.threads = new Thread(() -> {
                deviceVerifyWait.add(bot);
                bot.getLogger().warning("\u5f53\u524d\u767b\u5f55\u7684QQ\uff08" + bot.getId() + "\uff09\u9700\u8981\u8bbe\u5907\u9501\u9a8c\u8bc1");
                bot.getLogger().warning("\u8bf7\u6253\u5f00\u4ee5\u4e0b\u94fe\u63a5\u8fdb\u884c\u9a8c\u8bc1");
                bot.getLogger().warning(verifyUrl);
                bot.getLogger().warning("\u9a8c\u8bc1\u5b8c\u6210\u540e\uff0c\u8bf7\u8f93\u5165\u6307\u4ee4 /miraiverify unsafedevice " + bot.getId());
                bot.getLogger().warning("\u5982\u9700\u53d6\u6d88\u767b\u5f55\uff0c\u8bf7\u8f93\u5165\u6307\u4ee4 /miraiverify cancel " + bot.getId());
                bot.getLogger().warning("\u5982\u9700\u5e2e\u52a9\uff0c\u8bf7\u53c2\u9605: https://wiki.miraimc.dreamvoid.me/troubleshoot/verify-guide#device-locker");
                while (deviceVerifyWait.contains(bot) && !deviceVerifyCode.containsKey(bot)) {
                }
            });
            this.threads.start();
            this.threads.join();
        }
        catch (IllegalThreadStateException | InterruptedException e) {
            bot.getLogger().warning("\u542f\u52a8\u9a8c\u8bc1\u7ebf\u7a0b\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
            throw this.loginErrorException;
        }
        if (deviceVerifyCode.containsKey(bot)) {
            deviceVerifyWait.remove(bot);
            deviceVerifyCode.remove(bot);
            return null;
        }
        deviceVerifyWait.remove(bot);
        deviceVerifyCode.remove(bot);
        throw this.loginCancelException;
    }

    public static void solve(long BotAccount) throws NoSuchElementException {
        deviceVerifyCode.put(Bot.getInstance((long)BotAccount), "continue");
        deviceVerifyWait.remove(Bot.getInstance((long)BotAccount));
    }

    public static void solve(long BotAccount, String Code) throws NoSuchElementException {
        deviceVerifyCode.put(Bot.getInstance((long)BotAccount), Code);
        deviceVerifyWait.remove(Bot.getInstance((long)BotAccount));
    }

    public static void cancel(long BotAccount) throws NoSuchElementException {
        deviceVerifyWait.remove(Bot.getInstance((long)BotAccount));
    }

    public static void cancelAll() {
        deviceVerifyWait.clear();
        deviceVerifyCode.clear();
    }
}

