/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.bukkit.event.message.postsend;

import java.util.Objects;
import net.mamoe.mirai.event.events.MessagePostSendEvent;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageKey;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.QuoteReply;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractMessagePostSendEvent
extends Event {
    private final MessagePostSendEvent<?> event;
    private static final HandlerList handlers = new HandlerList();

    public AbstractMessagePostSendEvent(MessagePostSendEvent<?> event) {
        super(true);
        this.event = event;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public long getBotID() {
        return this.event.getBot().getId();
    }

    public long getTargetID() {
        return this.event.getTarget().getId();
    }

    public String getMessage() {
        return this.event.getMessage().contentToString();
    }

    @Deprecated
    public String getMessageContent() {
        return this.event.getMessage().contentToString();
    }

    public String getMessageToMiraiCode() {
        return this.event.getMessage().serializeToMiraiCode();
    }

    public String getMessageToString() {
        return this.event.getMessage().toString();
    }

    public String toString() {
        return this.event.toString();
    }

    public void recall() {
        MessageSource.recall((MessageChain)this.event.getMessage());
    }

    public void recall(long delayTime) {
        MessageSource.recallIn((MessageChain)this.event.getMessage(), (long)delayTime);
    }

    public long getQuoteReplySenderID() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getFromId() : 0L;
    }

    @Nullable
    public String getQuoteReplyMessage() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getOriginalMessage().contentToString() : null;
    }

    @Nullable
    public String getQuoteReplyMessageToString() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getOriginalMessage().toString() : null;
    }

    @Nullable
    public String getQuoteReplyMessageContent() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getOriginalMessage().toString() : null;
    }

    @Nullable
    public String getQuoteReplyMessageToMiraiCode() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getOriginalMessage().serializeToMiraiCode() : null;
    }
}

