/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.bukkit.event.message.passive;

import java.io.IOException;
import me.dreamvoid.miraimc.api.bot.MiraiFriend;
import me.dreamvoid.miraimc.bukkit.event.message.passive.AbstractMessageEvent;
import me.dreamvoid.miraimc.event.EventType;
import me.dreamvoid.miraimc.httpapi.MiraiHttpAPI;
import me.dreamvoid.miraimc.httpapi.exception.AbnormalStatusException;
import me.dreamvoid.miraimc.httpapi.response.FetchMessage;
import me.dreamvoid.miraimc.internal.Utils;
import net.mamoe.mirai.event.events.FriendMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;

public class MiraiFriendMessageEvent
extends AbstractMessageEvent {
    private FriendMessageEvent event;
    private final long BotID;
    private final long SenderID;
    private final String NickName;

    public MiraiFriendMessageEvent(FriendMessageEvent event) {
        super((MessageEvent)event);
        this.event = event;
        this.BotID = event.getBot().getId();
        this.SenderID = event.getSender().getId();
        this.NickName = event.getSender().getNick();
    }

    public MiraiFriendMessageEvent(long BotAccount, FetchMessage.Data data) {
        super(BotAccount, data);
        this.BotID = BotAccount;
        this.SenderID = data.sender.id;
        this.NickName = data.sender.nickname;
    }

    @Override
    public String getSenderName() {
        return this.NickName;
    }

    @Override
    public void sendMessage(String message) {
        if (this.getType() == EventType.CORE) {
            super.sendMessage(message);
        } else if (this.getType() == EventType.HTTPAPI) {
            try {
                MiraiHttpAPI.INSTANCE.sendFriendMessage(MiraiHttpAPI.Bots.get(this.BotID), this.SenderID, message);
            }
            catch (IOException | AbnormalStatusException e) {
                Utils.logger.warning("\u53d1\u9001\u6d88\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
            }
        }
    }

    @Override
    public void sendMessageMirai(String message) {
        if (this.getType() == EventType.CORE) {
            super.sendMessageMirai(message);
        } else if (this.getType() == EventType.HTTPAPI) {
            try {
                MiraiHttpAPI.INSTANCE.sendFriendMessage(MiraiHttpAPI.Bots.get(this.BotID), this.SenderID, message);
            }
            catch (IOException | AbnormalStatusException e) {
                Utils.logger.warning("\u53d1\u9001\u6d88\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
            }
        }
    }

    public MiraiFriend getFriend() {
        return new MiraiFriend(this.event.getBot(), this.getSenderID());
    }
}

