/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.bukkit.event.message.passive;

import java.util.Objects;
import me.dreamvoid.miraimc.event.EventType;
import me.dreamvoid.miraimc.httpapi.response.FetchMessage;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageKey;
import net.mamoe.mirai.message.data.QuoteReply;
import net.mamoe.mirai.message.data.SingleMessage;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractMessageEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private MessageEvent event;
    private final EventType type;
    private final long BotID;
    private final long SenderID;
    private final String SenderName;
    private String MessageContent;
    private String MessageMiraiCode;
    private int Time;

    public AbstractMessageEvent(MessageEvent event) {
        super(true);
        this.event = event;
        this.type = EventType.CORE;
        this.BotID = event.getBot().getId();
        this.SenderID = event.getSender().getId();
        this.SenderName = event.getSenderName();
        this.MessageContent = event.getMessage().contentToString();
        this.MessageMiraiCode = event.getMessage().serializeToMiraiCode();
        this.Time = event.getTime();
    }

    public AbstractMessageEvent(long BotID, FetchMessage.Data data) {
        super(true);
        this.type = EventType.HTTPAPI;
        this.BotID = BotID;
        this.SenderID = data.sender.id;
        this.SenderName = data.sender.nickname + data.sender.memberName;
        block10: for (FetchMessage.Data.MessageChain chain : data.messageChain) {
            switch (chain.type) {
                case "Source": {
                    this.Time = chain.time;
                    continue block10;
                }
                case "Code": {
                    this.MessageMiraiCode = chain.code;
                    continue block10;
                }
                case "Plain": {
                    this.MessageContent = String.format("%s%s", this.MessageContent, chain.text);
                    continue block10;
                }
            }
            this.MessageContent = String.format("%s[%s]", this.MessageContent, chain.type);
        }
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public long getBotID() {
        return this.BotID;
    }

    public long getSenderID() {
        return this.SenderID;
    }

    public String getSenderName() {
        return this.SenderName;
    }

    @Deprecated
    public String getSenderNick() {
        return this.event.getSender().getNick();
    }

    public String getMessage() {
        return this.MessageContent;
    }

    @Deprecated
    public String getMessageContent() {
        return this.event.getMessage().contentToString();
    }

    public String getMessageToString() {
        return this.event.getMessage().toString();
    }

    public String getMessageToMiraiCode() {
        return this.MessageMiraiCode;
    }

    public int getTime() {
        return this.Time;
    }

    public String toString() {
        return this.event.toString();
    }

    public void reply(String message) {
        this.event.getSender().sendMessage((Message)new MessageChainBuilder().append((SingleMessage)new QuoteReply(this.event.getMessage())).append((CharSequence)message).build());
    }

    public void replyMirai(String message) {
        this.event.getSender().sendMessage((Message)new MessageChainBuilder().append((SingleMessage)new QuoteReply(this.event.getMessage())).append((Message)MiraiCode.deserializeMiraiCode((String)message)).build());
    }

    public void sendMessage(String message) {
        this.event.getSender().sendMessage(message);
    }

    public void sendMessageMirai(String message) {
        this.event.getSender().sendMessage((Message)MiraiCode.deserializeMiraiCode((String)message));
    }

    public long getQuoteReplySenderID() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getFromId() : 0L;
    }

    @Nullable
    public String getQuoteReplyMessage() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getOriginalMessage().contentToString() : null;
    }

    @Nullable
    public String getQuoteReplyMessageToString() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getOriginalMessage().toString() : null;
    }

    @Nullable
    public String getQuoteReplyMessageContent() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getOriginalMessage().toString() : null;
    }

    @Nullable
    public String getQuoteReplyMessageToMiraiCode() {
        QuoteReply quoteReply = (QuoteReply)this.event.getMessage().get((MessageKey)QuoteReply.Key);
        return !Objects.isNull(quoteReply) ? quoteReply.getSource().getOriginalMessage().serializeToMiraiCode() : null;
    }

    public EventType getType() {
        return this.type;
    }
}

