/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.bukkit.event.message;

import net.mamoe.mirai.event.events.ImageUploadEvent;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class MiraiImageUploadEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final ImageUploadEvent event;

    public MiraiImageUploadEvent(ImageUploadEvent event) {
        super(true);
        this.event = event;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public long getBotID() {
        return this.event.getBot().getId();
    }

    public long getTargetID() {
        return this.event.getTarget().getId();
    }

    public String calculateResourceID() {
        return this.event.getSource().calculateResourceId();
    }

    public byte[] getImageMd5() {
        return this.event.getSource().getMd5();
    }

    public byte[] getImageSha1() {
        return this.event.getSource().getSha1();
    }

    public String getImageName() {
        return this.event.getSource().getFormatName();
    }

    public long getImageSize() {
        return this.event.getSource().getSize();
    }

    public String toString() {
        return this.event.toString();
    }

    public static class Failed
    extends MiraiImageUploadEvent {
        final ImageUploadEvent.Failed event;

        public Failed(ImageUploadEvent.Failed event) {
            super((ImageUploadEvent)event);
            this.event = event;
        }

        public String getMessage() {
            return this.event.getMessage();
        }

        public int getErrorID() {
            return this.event.getErrno();
        }
    }

    public static class Succeed
    extends MiraiImageUploadEvent {
        final ImageUploadEvent.Succeed event;

        public Succeed(ImageUploadEvent.Succeed event) {
            super((ImageUploadEvent)event);
            this.event = event;
        }

        public String getImageID() {
            return this.event.getImage().getImageId();
        }

        public String getMiraiMsg() {
            return this.event.getImage().serializeToMiraiCode();
        }

        public boolean isEmoji() {
            return this.event.getImage().isEmoji();
        }
    }
}

