/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.bukkit;

import me.dreamvoid.miraimc.bukkit.BukkitPlugin;
import me.dreamvoid.miraimc.bukkit.event.message.passive.MiraiFriendMessageEvent;
import me.dreamvoid.miraimc.bukkit.event.message.passive.MiraiGroupMessageEvent;
import me.dreamvoid.miraimc.bukkit.event.message.passive.MiraiGroupTempMessageEvent;
import me.dreamvoid.miraimc.bukkit.event.message.passive.MiraiOtherClientMessageEvent;
import me.dreamvoid.miraimc.bukkit.event.message.passive.MiraiStrangerMessageEvent;
import me.dreamvoid.miraimc.httpapi.MiraiHttpAPI;
import me.dreamvoid.miraimc.httpapi.response.FetchMessage;
import me.dreamvoid.miraimc.internal.Config;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class MiraiHttpAPIResolver
implements Runnable {
    private final BukkitPlugin plugin;

    public MiraiHttpAPIResolver(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        MiraiHttpAPI api = new MiraiHttpAPI(Config.HttpApi.Url);
        for (long account : MiraiHttpAPI.Bots.keySet()) {
            try {
                String session = MiraiHttpAPI.Bots.get(account);
                FetchMessage fetchMessage = api.fetchMessage(session, Config.HttpApi.MessageFetch.Count);
                if (fetchMessage.code == 0) {
                    for (FetchMessage.Data data : fetchMessage.data) {
                        String type;
                        switch (type = data.type) {
                            case "FriendMessage": {
                                Bukkit.getPluginManager().callEvent((Event)new MiraiFriendMessageEvent(account, data));
                                break;
                            }
                            case "GroupMessage": {
                                Bukkit.getPluginManager().callEvent((Event)new MiraiGroupMessageEvent(account, data));
                                break;
                            }
                            case "TempMessage": {
                                Bukkit.getPluginManager().callEvent((Event)new MiraiGroupTempMessageEvent(account, data));
                                break;
                            }
                            case "StrangerMessage": {
                                Bukkit.getPluginManager().callEvent((Event)new MiraiStrangerMessageEvent(account, data));
                                break;
                            }
                            case "OtherClientMessage": {
                                Bukkit.getPluginManager().callEvent((Event)new MiraiOtherClientMessageEvent(account, data));
                            }
                        }
                    }
                    continue;
                }
                this.plugin.getLogger().warning("Unable to fetch " + account + "'s message, reason: " + fetchMessage.msg);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("An error occurred while fetching message for " + account + ": " + e);
            }
        }
    }
}

